/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths;

import chumbanotz.abyssaldepths.ADConfig;
import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.block.ADBlocks;
import chumbanotz.abyssaldepths.block.Seaweed;
import chumbanotz.abyssaldepths.entity.SeaSerpent;
import chumbanotz.abyssaldepths.entity.Seahorse;
import chumbanotz.abyssaldepths.entity.billfish.Sailfish;
import chumbanotz.abyssaldepths.entity.billfish.Swordfish;
import chumbanotz.abyssaldepths.entity.fish.Basslet;
import chumbanotz.abyssaldepths.entity.fish.Butterflyfish;
import chumbanotz.abyssaldepths.entity.fish.Clownfish;
import chumbanotz.abyssaldepths.entity.fish.CommonFish;
import chumbanotz.abyssaldepths.item.Goggles;
import chumbanotz.abyssaldepths.item.SpikeSword;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="abyssaldepths")
public class RegistryHandler {
    private static int entityId;

    @SubscribeEvent
    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)RegistryHandler.setRegistryName("seaweed", new Seaweed()));
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)RegistryHandler.setRegistryName("seaweed", new ItemBlock(ADBlocks.SEAWEED)), (Item)RegistryHandler.setRegistryName("goggles", new Goggles()), RegistryHandler.setRegistryName("short_billfish_spike", new Item()), RegistryHandler.setRegistryName("long_billfish_spike", new Item()), RegistryHandler.setRegistryName("spike_sword", new SpikeSword()), (Item)RegistryHandler.setRegistryName("bannerfish", new ItemFood(3, 0.4f, false)), (Item)RegistryHandler.setRegistryName("butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("cooked_butterflyfish", new ItemFood(6, 0.6f, false)), (Item)RegistryHandler.setRegistryName("masked_butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("raccoon_butterflyfish", new ItemFood(2, 0.1f, false)), (Item)RegistryHandler.setRegistryName("spotfin_butterflyfish", new ItemFood(2, 0.1f, false))});
    }

    @SubscribeEvent
    public static void onEntityEntryRegistry(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{RegistryHandler.createEntityEntry("fish", CommonFish.class, 8762546, 12307920).build(), RegistryHandler.createEntityEntry("clownfish", Clownfish.class, 13785366, 0xFFFFFF).build(), RegistryHandler.createEntityEntry("seahorse", Seahorse.class, 13818758, 0x778833).build(), RegistryHandler.createEntityEntry("butterflyfish", Butterflyfish.class, 8762546, 12307920).build(), RegistryHandler.createEntityEntry("masked_butterflyfish", Butterflyfish.Masked.class, 16438016, 3817060).build(), RegistryHandler.createEntityEntry("raccoon_butterflyfish", Butterflyfish.Raccoon.class, 16297728, 1513499).build(), RegistryHandler.createEntityEntry("spotfin_butterflyfish", Butterflyfish.Spotfin.class, 16311296, 16121335).build(), RegistryHandler.createEntityEntry("bannerfish", Butterflyfish.Banner.class, 16183797, 0x121212).build(), RegistryHandler.createEntityEntry("fairy_basslet", Basslet.Fairy.class, 12599507, 16693761).build(), RegistryHandler.createEntityEntry("blackcap_basslet", Basslet.BlackCap.class, 12599507, 0x121212).build(), RegistryHandler.createEntityEntry("sailfish", Sailfish.class, 1060456, 0xE0E0E0).build(), RegistryHandler.createEntityEntry("swordfish", Swordfish.class, 1060456, 0xE0E0E0).build(), RegistryHandler.createEntityEntry("sea_serpent", SeaSerpent.class, 5938242, 9398119).build()});
        RegistryHandler.addSpawns();
    }

    private static <T extends EntityLiving> EntityEntryBuilder<?> createEntityEntry(String name, Class<T> entityClass, int eggPrimary, int eggSecondary) {
        return RegistryHandler.createEntityEntry(name, entityClass).egg(eggPrimary, eggSecondary).tracker(80, 3, true);
    }

    private static <T extends Entity> EntityEntryBuilder<T> createEntityEntry(String name, Class<T> entityClass) {
        if (EntityLiving.class.isAssignableFrom(entityClass)) {
            LootTableList.func_186375_a((ResourceLocation)AbyssalDepths.prefix("entities/" + name));
            EntitySpawnPlacementRegistry.setPlacementType(entityClass, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
        return EntityEntryBuilder.create().entity(entityClass).id(AbyssalDepths.prefix(name), entityId++).name("abyssaldepths." + name);
    }

    private static void addSpawns() {
        if (ADConfig.SPAWNS.biomeWhitelist.length == 0) {
            return;
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            for (String modID : ADConfig.SPAWNS.biomeWhitelist) {
                if (biome.getRegistryName() != null && biome.getRegistryName().func_110624_b().equals(modID)) continue;
            }
            List waterEntries = biome.func_76747_a(EnumCreatureType.WATER_CREATURE);
            if (waterEntries.isEmpty()) continue;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                RegistryHandler.addSpawn(waterEntries, CommonFish.class, ADConfig.SPAWNS.fishWeight, 3, 5);
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) continue;
            RegistryHandler.addSpawn(waterEntries, CommonFish.class, ADConfig.SPAWNS.fishWeight, 3, 5);
            RegistryHandler.addSpawn(waterEntries, Clownfish.class, ADConfig.SPAWNS.clownfishWeight, 2, 3);
            RegistryHandler.addSpawn(waterEntries, Seahorse.class, ADConfig.SPAWNS.seahorseWeight, 1, 3);
            RegistryHandler.addSpawn(waterEntries, Butterflyfish.class, ADConfig.SPAWNS.butterflyfishWeight, 2, 5);
            RegistryHandler.addSpawn(waterEntries, Butterflyfish.Masked.class, ADConfig.SPAWNS.maskedButterflyfishWeight, 2, 5);
            RegistryHandler.addSpawn(waterEntries, Butterflyfish.Raccoon.class, ADConfig.SPAWNS.raccoonButterflyfishWeight, 3, 5);
            RegistryHandler.addSpawn(waterEntries, Butterflyfish.Spotfin.class, ADConfig.SPAWNS.spotfinButterflyfishWeight, 3, 5);
            RegistryHandler.addSpawn(waterEntries, Butterflyfish.Banner.class, ADConfig.SPAWNS.bannerfishWeight, 2, 5);
            RegistryHandler.addSpawn(waterEntries, Basslet.Fairy.class, ADConfig.SPAWNS.fairyBassletWeight, 1, 4);
            RegistryHandler.addSpawn(waterEntries, Basslet.BlackCap.class, ADConfig.SPAWNS.blackcapBassletWeight, 1, 4);
            RegistryHandler.addSpawn(waterEntries, Sailfish.class, ADConfig.SPAWNS.sailfishWeight, 1, 5);
            RegistryHandler.addSpawn(waterEntries, Swordfish.class, ADConfig.SPAWNS.swordfishWeight, 1, 4);
            RegistryHandler.addSpawn(waterEntries, SeaSerpent.class, ADConfig.SPAWNS.seaSerpentWeight, 1, 2);
        }
    }

    private static void addSpawn(List<Biome.SpawnListEntry> entries, Class<? extends EntityLiving> entityClass, int weight, int min, int max) {
        if (weight > 0) {
            entries.add(new Biome.SpawnListEntry(entityClass, weight, min, max));
        }
    }

    @SubscribeEvent
    public static void remapEntityEntries(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110623_a().equals("body_part")) continue;
            mapping.ignore();
        }
    }

    public static <T extends IForgeRegistryEntry<T>> T setRegistryName(String name, T entry) {
        ResourceLocation registryName = AbyssalDepths.prefix(name);
        if (entry instanceof Block) {
            ((Block)entry).func_149663_c(registryName.func_110624_b() + '.' + registryName.func_110623_a());
            ((Block)entry).func_149647_a(AbyssalDepths.CREATIVE_TAB);
        }
        if (entry instanceof Item) {
            ((Item)entry).func_77655_b(registryName.func_110624_b() + '.' + registryName.func_110623_a());
            ((Item)entry).func_77637_a(AbyssalDepths.CREATIVE_TAB);
        }
        return (T)((IForgeRegistryEntry)entry.setRegistryName(registryName));
    }
}

