/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.client.renderer;

import chumbanotz.abyssaldepths.AbyssalDepths;
import chumbanotz.abyssaldepths.client.model.ModelBillfish;
import chumbanotz.abyssaldepths.client.renderer.RenderAquaticCreature;
import chumbanotz.abyssaldepths.entity.billfish.Billfish;
import chumbanotz.abyssaldepths.entity.billfish.Swordfish;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.util.ResourceLocation;

public class RenderBillfish
extends RenderAquaticCreature<Billfish> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = new HashMap<String, ResourceLocation>();
    private static final ResourceLocation SAILFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/sailfish");
    private static final ResourceLocation SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/swordfish");
    private static final ResourceLocation BLUE_SWORDFISH_TEXTURE = AbyssalDepths.getEntityTexture("billfish/blue_swordfish");

    public RenderBillfish(RenderManager rendermanagerIn) {
        super(rendermanagerIn, new ModelBillfish(), 0.0f);
    }

    private ResourceLocation getBillfishTexture(Billfish billfish) {
        if (billfish instanceof Swordfish) {
            return ((Swordfish)billfish).isBlue() ? BLUE_SWORDFISH_TEXTURE : SWORDFISH_TEXTURE;
        }
        return SAILFISH_TEXTURE;
    }

    @Override
    protected void preRenderCallback(Billfish living, float partialTick) {
        if (living instanceof Swordfish) {
            GlStateManager.func_179152_a((float)1.3f, (float)1.3f, (float)1.3f);
        }
    }

    public ResourceLocation getEntityTexture(Billfish entity) {
        if (!entity.hasBanner() && !entity.hasStripes()) {
            return this.getBillfishTexture(entity);
        }
        String textureId = this.getTexture(entity);
        ResourceLocation layered = LAYERED_LOCATION_CACHE.get(textureId);
        if (layered == null) {
            layered = new ResourceLocation(textureId);
            String[] textures = new String[]{"abyssaldepths:" + this.getBillfishTexture(entity).func_110623_a(), null, null};
            if (entity.hasBanner()) {
                textures[1] = "abyssaldepths:textures/entity/billfish/banner.png";
            }
            if (entity.hasStripes()) {
                textures[2] = "abyssaldepths:textures/entity/billfish/stripes.png";
            }
            Minecraft.func_71410_x().func_110434_K().func_110579_a(layered, (ITextureObject)new LayeredTexture(textures));
            LAYERED_LOCATION_CACHE.put(textureId, layered);
        }
        return layered;
    }

    private String getTexture(Billfish billfishEntity) {
        String path = "abyssaldepths:textures/entity/billfish/" + ((Object)((Object)billfishEntity)).getClass().getSimpleName().replace("Entity", "").toLowerCase() + "/";
        if (billfishEntity instanceof Swordfish && ((Swordfish)billfishEntity).isBlue()) {
            path = path + "blue";
        }
        if (billfishEntity.hasBanner()) {
            path = path + "banner";
        }
        if (billfishEntity.hasStripes()) {
            path = path + "stripes";
        }
        return path + ".png";
    }
}

