/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity;

import chumbanotz.abyssaldepths.entity.WaterCreature;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Euler;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class Seahorse
extends WaterCreature
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(Seahorse.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> TAME_AMOUNT = EntityDataManager.func_187226_a(Seahorse.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MARK = EntityDataManager.func_187226_a(Seahorse.class, (DataSerializer)DataSerializers.field_187191_a);

    public Seahorse(World world) {
        super(world);
        this.func_70105_a(0.95f, 2.2f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(TAME_AMOUNT, (Object)((byte)(3 + this.field_70146_Z.nextInt(3))));
        this.field_70180_af.func_187214_a(MARK, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void initSchool() {
        super.initSchool();
        this.school.setMaxSize(6 + this.field_70146_Z.nextInt(2));
        this.school.setRadius((float)this.school.getMaxSize() * 1.2f);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    private void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityPlayer getOwner() {
        UUID uuid = this.func_184753_b();
        return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
    }

    @Override
    public boolean getTamed() {
        return this.func_184753_b() != null;
    }

    public int getTameAmount() {
        return ((Byte)this.field_70180_af.func_187225_a(TAME_AMOUNT)).byteValue();
    }

    private void setTameAmount(int amount) {
        this.field_70180_af.func_187227_b(TAME_AMOUNT, (Object)((byte)amount));
    }

    public int getMark() {
        return ((Byte)this.field_70180_af.func_187225_a(MARK)).byteValue();
    }

    private void setMark(int mark) {
        this.field_70180_af.func_187227_b(MARK, (Object)((byte)mark));
    }

    @Override
    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -1.1, 0.0), Material.field_151586_h, (Entity)this);
    }

    @Override
    public boolean getRotatePitch() {
        return false;
    }

    @Override
    public float getClosestPathDist() {
        return 2.0f;
    }

    @Override
    public boolean setRandomPath() {
        double x = this.field_70165_t + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        double y = this.field_70163_u + ((double)this.field_70146_Z.nextFloat() - 0.5) * 8.0 + this.addPathY();
        double z = this.field_70161_v + (4.0 + (double)this.field_70146_Z.nextFloat() * 5.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        if (this.onLand()) {
            x = this.field_70165_t + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            z = this.field_70161_v + (2.0 + (double)this.field_70146_Z.nextFloat() * 8.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        }
        if (this.isClearPath(x, y, z)) {
            this.targetVec = new Vec3d(x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void resetFleeDistance() {
        this.fleeDistance = 10.0 + (double)this.field_70146_Z.nextFloat() * 6.0;
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.fleeDistance = 24.0 + (double)this.field_70146_Z.nextFloat() * 8.0;
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Euler angle = new Euler(0.0f, this.field_70177_z, 0.0f);
            Vec3d vec = angle.rotateVector(-0.3f);
            passenger.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + passenger.func_70033_W() + 1.4, this.field_70161_v + vec.field_72449_c);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.school.ridinSolo() && this.getTamed()) {
            this.school.removeCreature(this);
            this.school.setOpenToCombine(false);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_184207_aI() || this.func_110167_bD()) {
            if (this.getTamed() && this.func_184207_aI() && this.func_184188_bt().get(0) == this.getOwner()) {
                this.targetVec = null;
            }
            this.followEntity = null;
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setColor(this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat());
        } else {
            this.setColor(0.79607844f, 0.8509804f, 0.43529412f);
        }
        this.setMark(this.field_70146_Z.nextInt(3));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_184207_aI() && this.func_82171_bF() && this.getTamed();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase passenger = (EntityLivingBase)this.func_184179_bs();
            if (!this.getTamed()) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.targetVec == null || this.field_70146_Z.nextInt(15) == 0) {
                        this.setRandomPath();
                    }
                    this.fleeFromEntity = passenger;
                    if (this.field_70146_Z.nextInt(50) == 0) {
                        this.setTameAmount(this.getTameAmount() - 1);
                        if (this.getTameAmount() <= 0 && passenger instanceof EntityPlayer) {
                            this.setOwnerId(passenger.func_110124_au());
                            this.fleeFromEntity = null;
                            this.fleeLookVec = null;
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.targetVec = null;
                            passenger.func_184210_p();
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    super.func_191986_a(strafe, vertical, forward);
                }
            } else {
                float f;
                float target = ADGlobal.wrapAngleAround(passenger.field_70177_z, this.field_70177_z);
                if (Math.abs(target - (f = this.field_70177_z + (target - this.field_70177_z) * 0.2f)) > 30.0f || this.dPosX * this.dPosX + this.dPosY * this.dPosY + this.dPosZ * this.dPosZ > 1.6000001778593287E-5) {
                    this.field_70759_as = this.field_70761_aq = f;
                    this.field_70177_z = this.field_70761_aq;
                    this.field_70126_B = this.field_70761_aq;
                }
                double speed = this.getMovementSpeed() * 1.8;
                float pitch = this.field_70125_A;
                this.field_70125_A = passenger.field_70125_A * 0.9f - 10.0f;
                Vec3d vec = this.func_70040_Z();
                this.field_70125_A = pitch;
                this.netSpeed = (float)(this.netSpeed + (speed * (double)passenger.field_191988_bg - this.netSpeed) * (double)0.1f);
                if (this.func_70090_H()) {
                    this.func_70091_d(MoverType.SELF, vec.field_72450_a * this.netSpeed, vec.field_72448_b * this.netSpeed, vec.field_72449_c * this.netSpeed);
                }
                super.func_191986_a(passenger.field_70702_br, vertical, 0.0f);
                this.handleLimbSwing();
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float dmg) {
        Entity entity = source.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(source, dmg);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.func_184207_aI()) {
            player.field_70177_z = this.field_70759_as;
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    private void playTameEffect(boolean tamed) {
        EnumParticleTypes enumparticletypes = tamed ? EnumParticleTypes.HEART : EnumParticleTypes.SMOKE_NORMAL;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70163_u <= 48.0;
    }

    public void func_70623_bb() {
        if (!this.getTamed()) {
            super.func_70623_bb();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("Mark", (byte)this.getMark());
        if (this.getTamed()) {
            compound.func_186854_a("OwnerUUID", this.func_184753_b());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setMark(compound.func_74771_c("Mark"));
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        }
    }
}

