/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.ai;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAIFindEntityNearest<T extends EntityLivingBase>
extends EntityAIBase {
    protected final EntityLiving mob;
    private final Predicate<EntityLivingBase> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private EntityLivingBase target;
    private final Class<T> classToCheck;

    public EntityAIFindEntityNearest(EntityLiving mobIn, Class<T> classToCheck, Predicate<EntityLivingBase> predicate) {
        this.mob = mobIn;
        this.classToCheck = classToCheck;
        this.predicate = predicate;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)mobIn);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.mob.func_70090_H() || this.mob.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        if (this.classToCheck == EntityPlayer.class) {
            double followRange = this.getFollowRange();
            this.target = this.mob.field_70170_p.func_184150_a(this.mob.field_70165_t, this.mob.field_70163_u, this.mob.field_70161_v, followRange, followRange, null, player -> this.predicate.apply(player));
        } else {
            List list = this.mob.field_70170_p.func_175647_a(this.classToCheck, this.mob.func_174813_aQ().func_186662_g(this.getFollowRange()), this.predicate);
            if (!list.isEmpty()) {
                list.sort(this.sorter);
                this.target = (EntityLivingBase)list.get(0);
            }
        }
        return EntityAITarget.func_179445_a((EntityLiving)this.mob, (EntityLivingBase)this.target, (boolean)false, (boolean)true);
    }

    public boolean func_75253_b() {
        if (!EntityAITarget.func_179445_a((EntityLiving)this.mob, (EntityLivingBase)this.target, (boolean)false, (boolean)false)) {
            return false;
        }
        double followRange = this.getFollowRange();
        if (this.mob.func_70068_e((Entity)this.target) > followRange * followRange) {
            return false;
        }
        return this.predicate.apply((Object)this.target);
    }

    public void func_75249_e() {
        this.mob.func_70624_b(this.target);
    }

    public void func_75251_c() {
        this.mob.func_70624_b(null);
        this.target = null;
    }

    private double getFollowRange() {
        IAttributeInstance iattributeinstance = this.mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }
}

