/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.entity.billfish;

import chumbanotz.abyssaldepths.entity.BodyPart;
import chumbanotz.abyssaldepths.entity.ComplexCreature;
import chumbanotz.abyssaldepths.entity.ai.EntityAIFindEntityNearest;
import chumbanotz.abyssaldepths.entity.ai.EntityAIHurtByTarget;
import chumbanotz.abyssaldepths.entity.fish.CommonFish;
import chumbanotz.abyssaldepths.util.ADGlobal;
import chumbanotz.abyssaldepths.util.Bone;
import chumbanotz.abyssaldepths.util.Euler;
import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class Billfish
extends ComplexCreature {
    protected static final DataParameter<Byte> MARKINGS = EntityDataManager.func_187226_a(Billfish.class, (DataSerializer)DataSerializers.field_187191_a);
    private int attackTime;
    private final BodyPart[] partList = new BodyPart[4];
    private final Bone baseBone = new Bone();
    private final Bone[] boneList = new Bone[4];
    private final Euler[] targetAngles = new Euler[4];

    public Billfish(World world) {
        super(world);
        int i;
        this.baseBone.setLength(0.0f);
        this.boneList[0] = new Bone(this.baseBone);
        this.boneList[0].setLength(this.getPartLength()[0] / 16.0f);
        for (i = 1; i < this.boneList.length; ++i) {
            this.boneList[i] = new Bone(i == 1 ? this.baseBone : this.boneList[i - 1]);
            this.boneList[i].setLength(-this.getPartLength()[i] / 16.0f);
        }
        for (i = 0; i < this.partList.length; ++i) {
            this.targetAngles[i] = new Euler();
            this.partList[i] = new BodyPart(this, this.getPartLength()[i] / 16.0f);
        }
        this.updateParts();
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, new EntityAIFindEntityNearest<CommonFish>((EntityLiving)this, CommonFish.class, (Predicate<EntityLivingBase>)((Predicate)Entity::func_70090_H)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MARKINGS, (Object)0);
    }

    public boolean hasBanner() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 1) != 0;
    }

    protected void setBanner(boolean banner) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(banner ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasStripes() {
        return ((Byte)this.field_70180_af.func_187225_a(MARKINGS) & 2) != 0;
    }

    protected void setStripes(boolean stripes) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(MARKINGS);
        this.field_70180_af.func_187227_b(MARKINGS, (Object)(stripes ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    protected abstract float[] getPartLength();

    protected abstract double getStrikeRange();

    protected abstract float getAttackReach();

    protected abstract int getMaxAttackTime();

    @Override
    public BodyPart[] getParts() {
        return this.partList;
    }

    @Override
    public Bone getBaseBone() {
        return this.baseBone;
    }

    @Override
    public Bone[] getBoneList() {
        return this.boneList;
    }

    @Override
    public void updateYawRotations(float partialTick) {
        for (int i = this.boneList.length - 1; i > 1; --i) {
            if (partialTick == 1.0f) {
                this.targetAngles[i].y = this.targetAngles[i - 1].y;
                this.boneList[i].getRotation().y += this.targetAngles[i].y;
                continue;
            }
            this.boneList[i].getRotation().y += this.targetAngles[i].y + (this.targetAngles[i - 1].y - this.targetAngles[i].y) * partialTick;
        }
        this.targetAngles[1].y = -(this.currentYaw - this.prevCurrentYaw) * 1.4f;
        this.targetAngles[0].y = (this.currentYaw - this.prevCurrentYaw) * 1.4f;
        float moveScale = this.field_184618_aE + (this.field_70721_aZ - this.field_184618_aE) * partialTick;
        float moveTick = this.field_184619_aG - this.field_70721_aZ * (1.0f - partialTick);
        if (moveScale > 1.0f) {
            moveScale = 1.0f;
        }
        for (int i = 0; i < this.boneList.length; ++i) {
            float breatheAnim = MathHelper.func_76126_a((float)(0.1f * ((float)this.field_70173_aa + partialTick - (float)i * 1.4f)));
            float moveAnim = MathHelper.func_76126_a((float)(0.7f * (moveTick - (float)i * 1.4f))) * moveScale;
            this.boneList[i].getRotation().y += breatheAnim * 1.1f;
            this.boneList[i].getRotation().y += moveAnim * 8.0f;
        }
    }

    @Override
    protected void moveCreature() {
        super.moveCreature();
        if (this.attackTime > this.getMaxAttackTime() && this.func_70089_S()) {
            float dmg = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            Entity entity = ADGlobal.getPointedEntity((EntityLivingBase)this, this.getAttackReach());
            ComplexCreature base = entity instanceof BodyPart ? ((BodyPart)entity).getParent() : null;
            boolean attack = true;
            if (base != null && ((Object)((Object)base)).getClass().equals(((Object)((Object)this)).getClass())) {
                attack = false;
            }
            if (this.func_70638_az() == base || this.field_70146_Z.nextInt(160) == 0) {
                attack = true;
            }
            if (entity != null && attack) {
                this.eatOrDamageEntity(entity, dmg);
            }
        }
        --this.attackTime;
    }

    @Override
    public double moveByTarget(EntityLivingBase target) {
        if (this.attackTime > 0) {
            this.func_70671_ap().func_75651_a((Entity)target, this.attackTime > this.getMaxAttackTime() ? 15.0f : 0.0f, 85.0f);
        } else {
            this.func_70671_ap().func_75651_a((Entity)target, 8.0f, 85.0f);
        }
        double strikeRange = this.getStrikeRange();
        if (this.attackTime <= 0 && this.func_70068_e((Entity)target) < strikeRange * strikeRange && this.field_70146_Z.nextInt(4) == 0) {
            double x = target.field_70165_t - this.field_70165_t;
            double y = target.field_70163_u - this.field_70163_u;
            double z = target.field_70161_v - this.field_70161_v;
            double d = Math.sqrt(x * x + y * y + z * z);
            double scale = this.getMovementSpeed() / 0.8;
            this.field_70159_w = x / d * scale;
            this.field_70181_x = y / d * scale;
            this.field_70179_y = z / d * scale;
            this.attackTime = 16 + this.field_70146_Z.nextInt(5);
        }
        return this.attackTime > 0 ? 0.0 : this.getMovementSpeed() * 1.2;
    }

    @Override
    public boolean findNewPath() {
        return this.field_70146_Z.nextInt(45) == 0 || this.onLand() && this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public boolean setRandomPath() {
        double x = this.field_70165_t + (6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        double y = this.field_70163_u + ((double)this.field_70146_Z.nextFloat() - 0.5) * 8.0 + this.addPathY();
        double z = this.field_70161_v + (6.0 + (double)this.field_70146_Z.nextFloat() * 6.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        if (this.onLand()) {
            x = this.field_70165_t + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
            z = this.field_70161_v + (4.0 + (double)this.field_70146_Z.nextFloat() * 12.0) * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        }
        if (this.isClearPath(x, y, z)) {
            this.targetVec = new Vec3d(x, y, z);
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Banner", this.hasBanner());
        compound.func_74757_a("Stripes", this.hasStripes());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBanner(compound.func_74767_n("Banner"));
        this.setStripes(compound.func_74767_n("Stripes"));
    }
}

