/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.util;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Euler {
    public float x;
    public float y;
    public float z;

    public Euler() {
        this.setAngles(0.0f, 0.0f, 0.0f);
    }

    public Euler(float x, float y, float z) {
        this.setAngles(x, y, z);
    }

    public Euler(Euler angle) {
        this.setAngles(angle);
    }

    public Euler(Vec3d vec) {
        this.setAngles(vec);
    }

    public Euler clone() {
        return new Euler(this);
    }

    public void setAngles(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setAngles(Euler angle) {
        this.x = angle.x;
        this.y = angle.y;
        this.z = angle.z;
    }

    public void setAngles(Vec3d vec) {
        this.x = (float)Math.atan2(vec.field_72448_b, Math.sqrt(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
        this.y = (float)Math.atan2(vec.field_72450_a, vec.field_72449_c);
        this.z = 0.0f;
    }

    public void rotate(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void rotate(Euler angle) {
        this.x += angle.x;
        this.y += angle.y;
        this.z += angle.z;
    }

    public Vec3d rotateVector(float length) {
        if (length == 0.0f) {
            return Vec3d.field_186680_a;
        }
        Euler rad = this.toRad();
        float yawOffset = 1.5707964f;
        float xSin = MathHelper.func_76126_a((float)rad.x);
        float xCos = MathHelper.func_76134_b((float)rad.x);
        float ySin = MathHelper.func_76126_a((float)(rad.y + yawOffset));
        float yCos = MathHelper.func_76134_b((float)(rad.y + yawOffset));
        float zSin = MathHelper.func_76126_a((float)rad.z);
        float zCos = MathHelper.func_76134_b((float)rad.z);
        double xOffset = xCos * yCos;
        double yOffset = xCos * ySin * zSin - zCos * xSin;
        double zOffset = xSin * zSin + xCos * zCos * ySin;
        return new Vec3d(xOffset * (double)length, yOffset * (double)length, zOffset * (double)length);
    }

    public Euler getRotated(float x, float y, float z) {
        Euler angle = new Euler(this);
        angle.rotate(x, y, z);
        return angle;
    }

    public Euler getRotated(Euler angle) {
        Euler newAngle = new Euler(this);
        newAngle.rotate(angle);
        return newAngle;
    }

    public Euler toRad() {
        float conv = (float)Math.PI / 180;
        return new Euler(this.x * conv, this.y * conv, this.z * conv);
    }

    public Euler toDegrees() {
        float conv = 57.295776f;
        return new Euler(this.x * conv, this.y * conv, this.z * conv);
    }
}

