/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.abyssaldepths.world;

import chumbanotz.abyssaldepths.ADConfig;
import chumbanotz.abyssaldepths.block.ADBlocks;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ADWorldGen
implements IWorldGenerator {
    private final int priority;

    public ADWorldGen(int priority) {
        this.priority = priority;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int y;
        int z;
        int x;
        int i;
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        int posX = chunkX * 16;
        int posZ = chunkZ * 16;
        Biome biome = world.func_180494_b(new BlockPos(posX, 0, posZ));
        boolean waterBiome = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        boolean swampBiome = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
        if (this.priority == 0 && ADConfig.GENERATION.generateRocks && waterBiome) {
            for (i = 0; i < 8; ++i) {
                x = posX + rand.nextInt(16) + 8;
                z = posZ + rand.nextInt(16) + 8;
                y = ADWorldGen.nextInt(rand, world.func_189649_b(x, z) * 2);
                ADWorldGen.generateRocks(world, rand, x, y, z);
            }
        }
        if (this.priority == 1 && ADConfig.GENERATION.generateSeaweed && (waterBiome || swampBiome)) {
            for (i = 0; i < 10; ++i) {
                x = posX + rand.nextInt(16) + 8;
                z = posZ + rand.nextInt(16) + 8;
                y = ADWorldGen.nextInt(rand, world.func_189649_b(x, z) * 2);
                ADWorldGen.generateSeaweed(world, rand, x, y, z);
            }
        }
    }

    private static void generateRocks(World world, Random rand, int i, int j, int k) {
        for (int l = 0; l < 3; ++l) {
            int x = i + rand.nextInt(5) - rand.nextInt(5);
            int y = j + rand.nextInt(6) - rand.nextInt(6);
            int z = k + rand.nextInt(5) - rand.nextInt(5);
            int focX = x + (2 + rand.nextInt(3)) * (rand.nextBoolean() ? 1 : -1);
            int focY = y + rand.nextInt(3) - rand.nextInt(3);
            int focZ = z + (2 + rand.nextInt(3)) * (rand.nextBoolean() ? 1 : -1);
            int focX1 = x + (2 + rand.nextInt(3)) * (rand.nextBoolean() ? 1 : -1);
            int focY1 = y + rand.nextInt(3) - rand.nextInt(3);
            int focZ1 = z + (2 + rand.nextInt(3)) * (rand.nextBoolean() ? 1 : -1);
            IBlockState blockState = world.func_180495_p(new BlockPos(focX, focY, focZ));
            IBlockState blockState1 = world.func_180495_p(new BlockPos(focX1, focY1, focZ1));
            if ((!blockState.func_185904_a().func_76220_a() || blockState.func_177230_c() == Blocks.field_150406_ce || blockState1.func_177230_c() != Blocks.field_150355_j) && (blockState.func_177230_c() != Blocks.field_150355_j || !blockState1.func_185904_a().func_76220_a() || blockState1.func_177230_c() == Blocks.field_150406_ce)) continue;
            int lowerX = focX < focX1 ? focX : focX1;
            int lowerY = focY < focY1 ? focY : focY1;
            int lowerZ = focZ < focZ1 ? focZ : focZ1;
            int dX = Math.abs(focX - focX1);
            int dY = Math.abs(focY - focY1);
            int dZ = Math.abs(focZ - focZ1);
            int countOffset = 4;
            int thickness = 2;
            boolean blackClay = rand.nextInt(3) != 0;
            int oreX = 0;
            int oreY = 0;
            int oreZ = 0;
            for (int countX = 0; countX <= dX + countOffset * 2; ++countX) {
                for (int countY = 0; countY <= dY + countOffset * 2; ++countY) {
                    for (int countZ = 0; countZ <= dZ + countOffset * 2; ++countZ) {
                        boolean suitableSize;
                        int xx = lowerX + countX - countOffset;
                        int yy = lowerY + countY - countOffset;
                        int zz = lowerZ + countZ - countOffset;
                        boolean bl = suitableSize = ADWorldGen.getDistance(xx, yy, zz, focX, focY, focZ) + ADWorldGen.getDistance(xx, yy, zz, focX1, focY1, focZ1) < MathHelper.func_76129_c((float)(dX * dX + dY * dY + dZ * dZ)) + (float)(thickness / 2);
                        if (!suitableSize) continue;
                        world.func_180501_a(new BlockPos(xx, yy - (int)((float)dY / 2.0f + 0.9f + rand.nextFloat() * 0.2f), zz), blackClay ? Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK) : Blocks.field_150406_ce.func_176223_P(), 2);
                        if ((oreX != 0 || oreY != 0 || oreZ != 0) && rand.nextInt(5) != 0) continue;
                        oreX = xx;
                        oreY = yy - (int)((float)dY / 2.0f + 1.0f);
                        oreZ = zz;
                    }
                }
            }
            BlockPos pos = new BlockPos(oreX, oreY, oreZ);
            if (rand.nextInt(4) == 0) {
                world.func_180501_a(pos, Blocks.field_150365_q.func_176223_P(), 2);
                continue;
            }
            if (rand.nextInt(5) == 0) {
                world.func_180501_a(pos, Blocks.field_150366_p.func_176223_P(), 2);
                continue;
            }
            if (rand.nextInt(8) == 0) {
                world.func_180501_a(pos, Blocks.field_150369_x.func_176223_P(), 2);
                continue;
            }
            if (rand.nextInt(10) == 0) {
                world.func_180501_a(pos, Blocks.field_150352_o.func_176223_P(), 2);
                continue;
            }
            if (rand.nextInt(100) != 0) continue;
            world.func_180501_a(pos, Blocks.field_150482_ag.func_176223_P(), 2);
        }
    }

    private static void generateSeaweed(World world, Random rand, int i, int j, int k) {
        for (int l = 0; l < 60; ++l) {
            int x = i + rand.nextInt(8) - rand.nextInt(8);
            int y = j + rand.nextInt(4) - rand.nextInt(4);
            int z = k + rand.nextInt(8) - rand.nextInt(8);
            int seaweedHeight = 1 + rand.nextInt(rand.nextInt(3) + 1);
            for (int l1 = 0; l1 < seaweedHeight; ++l1) {
                if (!ADBlocks.SEAWEED.func_176196_c(world, new BlockPos(x, y + l1, z))) continue;
                int count = 1;
                while (world.func_180495_p(new BlockPos(x, y - count, z)) == ADBlocks.SEAWEED) {
                    ++count;
                }
                if (count >= 4) continue;
                world.func_180501_a(new BlockPos(x, y + l1, z), ADBlocks.SEAWEED.func_176223_P(), 2);
            }
        }
    }

    private static float getDistance(int x, int y, int z, int x1, int y1, int z1) {
        int dx = x - x1;
        int dy = y - y1;
        int dz = z - z1;
        return MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
    }

    private static int nextInt(Random rand, int i) {
        return i <= 1 ? 0 : rand.nextInt(i);
    }
}

