/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block;

import java.util.ArrayList;
import java.util.List;
import muka2533.mods.asphaltmod.AsphaltMod;
import muka2533.mods.asphaltmod.block.BlockModelBase;
import muka2533.mods.asphaltmod.block.IVariationBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockLine
extends BlockModelBase
implements IVariationBlock {
    public static List<BlockLine> blockLineList = new ArrayList<BlockLine>();
    public static final PropertyEnum<EnumColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);
    public boolean hasOrange;

    public BlockLine(String blockName) {
        this(blockName, true);
    }

    public BlockLine(String blockName, boolean hasOrange) {
        super(Material.field_151593_r, blockName, 0.1f, 1.0f);
        this.func_149647_a(AsphaltMod.TAB_LINE);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)((Object)EnumColor.WHITE)));
        this.hasOrange = hasOrange;
        blockLineList.add(this);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumColor)((Object)state.func_177229_b(COLOR))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, EnumColor.WHITE.getMetadata()));
        if (this.hasOrange) {
            items.add((Object)new ItemStack((Block)this, 1, EnumColor.ORANGE.getMetadata()));
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)EnumColor.byMetadata(meta % 2)));
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)((meta - meta % 2) / 2)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() * 2 + ((EnumColor)((Object)state.func_177229_b(COLOR))).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
    }

    @Override
    public void onRegisterItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumColor.WHITE.func_176610_l(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumColor.ORANGE.func_176610_l(), "inventory"));
    }

    @Override
    public String getVariationName(int meta) {
        return EnumColor.byMetadata(meta).unlocalizedName;
    }

    public static boolean isEqualsLines(Block block) {
        boolean result = false;
        for (int i = 0; i < blockLineList.size(); ++i) {
            if (!blockLineList.get(i).equals(block)) continue;
            result = true;
        }
        return result;
    }

    public static enum EnumColor implements IStringSerializable
    {
        WHITE(0, "white"),
        ORANGE(1, "orange");

        private static final EnumColor[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumColor(int meta, String name) {
            this(meta, name, name);
        }

        private EnumColor(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static EnumColor byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumColor[EnumColor.values().length];
            EnumColor[] enumColorArray = EnumColor.values();
            int n = enumColorArray.length;
            for (int i = 0; i < n; ++i) {
                EnumColor blockplanks$enumtype;
                EnumColor.META_LOOKUP[blockplanks$enumtype.getMetadata()] = blockplanks$enumtype = enumColorArray[i];
            }
        }
    }
}

