/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block;

import java.util.ArrayList;
import muka2533.mods.asphaltmod.block.BlockBase;
import muka2533.mods.asphaltmod.block.IVariationBlock;
import muka2533.mods.asphaltmod.block.tileentity.TileEntityRoadSign;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModItem;
import muka2533.mods.asphaltmod.util.AsphaltModUtil;
import muka2533.mods.asphaltmod.util.Sign;
import muka2533.mods.asphaltmod.util.SignText;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMetalPole
extends BlockBase
implements IVariationBlock {
    public static final PropertyEnum<EnumAngle> ANGLE = PropertyEnum.func_177709_a((String)"angle", EnumAngle.class);
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockMetalPole(String blockName) {
        super(Material.field_76233_E, blockName, 2.0f, 30.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.ORANGE)).func_177226_a(ANGLE, (Comparable)((Object)EnumAngle.DOWN)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand) != null && playerIn.func_184586_b(hand).func_77973_b() == AsphaltModItem.ROAD_SIGN_PANEL) {
            int type = ((EnumType)((Object)state.func_177229_b(TYPE))).getIndex();
            int angle = ((EnumAngle)((Object)state.func_177229_b(ANGLE))).getIndex();
            worldIn.func_175656_a(pos, AsphaltModBlock.ROAD_SIGN.func_176223_P());
            TileEntityRoadSign tile = (TileEntityRoadSign)worldIn.func_175625_s(pos);
            NBTTagCompound nbt = playerIn.func_184586_b(hand).func_77978_p();
            if (nbt != null) {
                String id = nbt.func_74779_i("dataID");
                int direction = AsphaltModUtil.getMiniDirection((EntityLivingBase)playerIn);
                double width = 1.0;
                double height = 1.0;
                ArrayList<SignText> signTexts = new ArrayList<SignText>();
                if (playerIn.func_70093_af()) {
                    hitY = 0.5f;
                }
                if (nbt.func_74769_h("width") != 0.0) {
                    width = nbt.func_74769_h("width");
                }
                if (nbt.func_74769_h("height") != 0.0) {
                    height = nbt.func_74769_h("height");
                }
                if (nbt.func_74781_a("signTexts") != null) {
                    NBTTagList tagList = (NBTTagList)nbt.func_74781_a("signTexts");
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        signTexts.add(SignText.loadSignFromNBT(tagList.func_150305_b(i)));
                    }
                }
                tile.setSign(new Sign(id, direction, hitY, height, width, signTexts));
            }
            tile.direction = AsphaltModUtil.getMiniDirection((EntityLivingBase)playerIn);
            tile.angle = angle;
            tile.color = type;
            tile.func_70296_d();
            if (!playerIn.field_71075_bZ.field_75098_d && playerIn.field_71071_by.func_70448_g().func_190916_E() - 1 <= 0) {
                playerIn.field_71071_by.func_70448_g().func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(ANGLE) == EnumAngle.DOWN) {
            return new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
        }
        if (state.func_177229_b(ANGLE) == EnumAngle.UP_X) {
            return new AxisAlignedBB(0.3, 0.3, 0.0, 0.7, 0.7, 1.0);
        }
        if (state.func_177229_b(ANGLE) == EnumAngle.UP_Z) {
            return new AxisAlignedBB(0.0, 0.3, 0.3, 1.0, 0.7, 0.7);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, EnumType.ORANGE.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.GRAY.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.WHITE.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.BROWN.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.BLACK.getMetadata()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta))).func_177226_a(ANGLE, (Comparable)((Object)EnumAngle.byIndex(meta % 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata() + ((EnumAngle)((Object)state.func_177229_b(ANGLE))).getIndex();
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH) {
            return iblockstate.func_177226_a(ANGLE, (Comparable)((Object)EnumAngle.UP_X));
        }
        if (facing == EnumFacing.WEST || facing == EnumFacing.EAST) {
            return iblockstate.func_177226_a(ANGLE, (Comparable)((Object)EnumAngle.UP_Z));
        }
        return iblockstate.func_177226_a(ANGLE, (Comparable)((Object)EnumAngle.DOWN));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ANGLE, TYPE});
    }

    @Override
    public void onRegisterItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.ORANGE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.ORANGE.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.GRAY.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.GRAY.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.WHITE.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.WHITE.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.BROWN.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.BROWN.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)EnumType.BLACK.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.BLACK.getUnlocalizedName() + ".obj", "inventory"));
    }

    @Override
    public String getVariationName(int meta) {
        return EnumType.byMetadata(meta).unlocalizedName;
    }

    public static enum EnumType implements IStringSerializable
    {
        ORANGE(0, 0, "orange"),
        GRAY(1, 3, "gray"),
        WHITE(2, 6, "white"),
        BROWN(3, 9, "brown"),
        BLACK(4, 12, "black");

        private static final EnumType[] META_LOOKUP;
        private final int index;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int index, int meta, String name) {
            this(index, meta, name, name);
        }

        private EnumType(int index, int meta, String name, String unlocalizedName) {
            this.index = index;
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static EnumType byIndex(int index) {
            if (index < 0 || index > 4) {
                index = 0;
            }
            return META_LOOKUP[index];
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta > 16) {
                meta = 0;
            }
            return META_LOOKUP[meta / 3];
        }

        public int getIndex() {
            return this.index;
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockplanks$enumtype;
                EnumType.META_LOOKUP[blockplanks$enumtype.getIndex()] = blockplanks$enumtype = enumTypeArray[i];
            }
        }
    }

    public static enum EnumAngle implements IStringSerializable
    {
        DOWN(0, "down"),
        UP_X(1, "up_x"),
        UP_Z(2, "up_z");

        private static final EnumAngle[] META_LOOKUP;
        private final int index;
        private final String name;

        private EnumAngle(int index, String name) {
            this(index, name, name);
        }

        private EnumAngle(int index, String name, String unlocalizedName) {
            this.index = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumAngle byIndex(int index) {
            if (index < 0 || index > 3) {
                index = 0;
            }
            return META_LOOKUP[index];
        }

        public int getIndex() {
            return this.index;
        }

        static {
            META_LOOKUP = new EnumAngle[3];
            EnumAngle[] enumAngleArray = EnumAngle.values();
            int n = enumAngleArray.length;
            for (int i = 0; i < n; ++i) {
                EnumAngle blockplanks$enumtype;
                EnumAngle.META_LOOKUP[blockplanks$enumtype.getIndex()] = blockplanks$enumtype = enumAngleArray[i];
            }
        }
    }
}

