/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.block;

import muka2533.mods.asphaltmod.block.BlockBase;
import muka2533.mods.asphaltmod.block.IVariationBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPole
extends BlockBase
implements IVariationBlock {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockPole(String blockName) {
        super(Material.field_76233_E, blockName, 2.0f, 30.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.ZERO)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TYPE) == EnumType.ZERO) {
            return new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, EnumType.ZERO.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.FOUR.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.TWO_DIAGONAL_0.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.ONE_0.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.TWO_SIDE_0.getMetadata()));
        items.add((Object)new ItemStack((Block)this, 1, EnumType.THREE_0.getMetadata()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState iblockstate = super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (meta == 0) {
            return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ZERO));
        }
        if (meta == 1) {
            return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.FOUR));
        }
        if (2 <= meta && meta <= 3) {
            if (placer.func_174811_aO() == EnumFacing.SOUTH || placer.func_174811_aO() == EnumFacing.NORTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_DIAGONAL_0));
            }
            if (placer.func_174811_aO() == EnumFacing.WEST || placer.func_174811_aO() == EnumFacing.EAST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_DIAGONAL_1));
            }
        } else if (4 <= meta && meta <= 7) {
            if (placer.func_174811_aO() == EnumFacing.SOUTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ONE_0));
            }
            if (placer.func_174811_aO() == EnumFacing.WEST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ONE_1));
            }
            if (placer.func_174811_aO() == EnumFacing.NORTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ONE_2));
            }
            if (placer.func_174811_aO() == EnumFacing.EAST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ONE_3));
            }
        } else if (8 <= meta && meta <= 11) {
            if (placer.func_174811_aO() == EnumFacing.SOUTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_SIDE_0));
            }
            if (placer.func_174811_aO() == EnumFacing.WEST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_SIDE_1));
            }
            if (placer.func_174811_aO() == EnumFacing.NORTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_SIDE_2));
            }
            if (placer.func_174811_aO() == EnumFacing.EAST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.TWO_SIDE_3));
            }
        } else if (12 <= meta && meta <= 15) {
            if (placer.func_174811_aO() == EnumFacing.SOUTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.THREE_0));
            }
            if (placer.func_174811_aO() == EnumFacing.WEST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.THREE_1));
            }
            if (placer.func_174811_aO() == EnumFacing.NORTH) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.THREE_2));
            }
            if (placer.func_174811_aO() == EnumFacing.EAST) {
                return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.THREE_3));
            }
        }
        return iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumType.ZERO));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @Override
    public void onRegisterItemModels(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.ZERO.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.FOUR.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.TWO_DIAGONAL_0.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)4, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.ONE_0.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)8, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.TWO_SIDE_0.getUnlocalizedName() + ".obj", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)12, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + "_" + EnumType.THREE_0.getUnlocalizedName() + ".obj", "inventory"));
    }

    @Override
    public String getVariationName(int meta) {
        return EnumType.byMetadata(meta).unlocalizedName;
    }

    public static enum EnumType implements IStringSerializable
    {
        ZERO(0, "zero"),
        FOUR(1, "four"),
        TWO_DIAGONAL_0(2, "two_diagonal_0", "two_diagonal"),
        TWO_DIAGONAL_1(3, "two_diagonal_1", "two_diagonal"),
        ONE_0(4, "one_0", "one"),
        ONE_1(5, "one_1", "one"),
        ONE_2(6, "one_2", "one"),
        ONE_3(7, "one_3", "one"),
        TWO_SIDE_0(8, "two_side_0", "two_side"),
        TWO_SIDE_1(9, "two_side_1", "two_side"),
        TWO_SIDE_2(10, "two_side_2", "two_side"),
        TWO_SIDE_3(11, "two_side_3", "two_side"),
        THREE_0(12, "three_0", "three"),
        THREE_1(13, "three_1", "three"),
        THREE_2(14, "three_2", "three"),
        THREE_3(15, "three_3", "three");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int meta, String name) {
            this(meta, name, name);
        }

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockplanks$enumtype;
                EnumType.META_LOOKUP[blockplanks$enumtype.getMetadata()] = blockplanks$enumtype = enumTypeArray[i];
            }
        }
    }
}

