/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.init;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class AsphaltModConfig {
    public static Configuration cfg;
    public static final String GENERAL = "General";
    public static boolean isGeneratorEnabled;
    public static int slopeEditorLength;
    public static float sidewalkEditerInterval;
    public static int flexibleLineEditerLength;
    public static int doubleMaterialBlockEditerLength;
    public static boolean downloadDigitalSignageScreens;
    public static boolean mobSpawningOnBlocks;

    public static void loadConfig(FMLPreInitializationEvent event) {
        cfg = new Configuration(event.getSuggestedConfigurationFile(), "2.3.9", true);
        System.out.println("Your previous AsphaltMod is ver." + cfg.getLoadedConfigVersion() + "");
        if (cfg.getLoadedConfigVersion().startsWith("1.")) {
            System.out.println("Your previous AsphaltMod is ver." + cfg.getLoadedConfigVersion() + "");
            System.out.println("AsphaltMod V1 and V2 are not compatible.");
            String lafClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            try {
                UIManager.setLookAndFeel(lafClassName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JLabel label = new JLabel("<html>AsphaltMod \u306e Ver.1.x.x \u3068 Ver.2.x.x \u306f\u4e92\u63db\u6027\u304c\u3042\u308a\u307e\u305b\u3093\u3002<br>Ver.1.x.x \u3067\u4f5c\u6210\u3057\u305f\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u3092 Ver.2.x.x \u3067\u8aad\u307f\u8fbc\u3080\u3068\u3001\u30c7\u30fc\u30bf\u304c\u6d88\u5931\u3059\u308b\u306e\u3067\u3054\u6ce8\u610f\u304f\u3060\u3055\u3044\u3002<br><br>AsphaltMod Ver.1.x.x and Ver.2.x.x are not compatible. <br> Please note that if you save data created in Ver.1.x.x with Ver.2.x.x, the data will be lost.</html>");
            label.setForeground(Color.RED);
            JOptionPane.showMessageDialog(null, label, "AsphaltMod", 2);
        }
        AsphaltModConfig.initConfig();
        AsphaltModConfig.syncConfig();
    }

    private static void initConfig() {
        cfg.addCustomCategoryComment(GENERAL, "A Setting of Asphalt Mod.");
        cfg.setCategoryLanguageKey(GENERAL, "config.asphaltmod.category.general");
    }

    public static void syncConfig() {
        isGeneratorEnabled = cfg.getBoolean("enabledGenerator", GENERAL, isGeneratorEnabled, "Oil Ore will be generated when this setting is true.", "config.property.enabledGenerator");
        slopeEditorLength = cfg.getInt("slopeEditerLength", GENERAL, slopeEditorLength, 0, 100, "The number of Slope Editor in Creative Tabs.");
        sidewalkEditerInterval = cfg.getFloat("sidewalkEditerInterval", GENERAL, sidewalkEditerInterval, 0.01f, 1.0f, "The Interval of Sidewalk Editer in Creative Tabs.");
        flexibleLineEditerLength = cfg.getInt("flexibleLineEditerLength", GENERAL, flexibleLineEditerLength, 0, 100, "The number of Flexible Line Editor in Creative Tabs.");
        doubleMaterialBlockEditerLength = cfg.getInt("doubleMaterialBlockEditerLength", GENERAL, doubleMaterialBlockEditerLength, 0, 100, "The number of Double Material Block Editor in Creative Tabs.");
        downloadDigitalSignageScreens = cfg.getBoolean("downloadDigitalSignageScreens", GENERAL, downloadDigitalSignageScreens, "This Mod download digital signage screen when it start up.");
        mobSpawningOnBlocks = cfg.getBoolean("mobSpawningOnBlocks", GENERAL, mobSpawningOnBlocks, "If false, Mobs will not spawn on blocks added by this mod.");
        cfg.save();
    }

    static {
        isGeneratorEnabled = true;
        slopeEditorLength = 10;
        sidewalkEditerInterval = 0.1f;
        flexibleLineEditerLength = 10;
        doubleMaterialBlockEditerLength = 10;
        downloadDigitalSignageScreens = true;
        mobSpawningOnBlocks = true;
    }
}

