/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.item;

import java.util.List;
import javax.annotation.Nullable;
import muka2533.mods.asphaltmod.AsphaltMod;
import muka2533.mods.asphaltmod.block.tileentity.TileEntityDoubleMaterial;
import muka2533.mods.asphaltmod.gui.GuiDoubleMaterialBlockEditor;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModConfig;
import muka2533.mods.asphaltmod.util.AsphaltModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDoubleMaterialBlockEditor
extends Item {
    public ItemDoubleMaterialBlockEditor(String itemName) {
        this.setRegistryName(itemName);
        this.func_77655_b(itemName);
        this.func_77637_a(AsphaltMod.TAB_EDITOR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            int i;
            for (i = 0; i < AsphaltModConfig.doubleMaterialBlockEditerLength; ++i) {
                items.add((Object)this.getItemStackWithNBT(this, i + 1, 0));
            }
            for (i = 0; i < AsphaltModConfig.doubleMaterialBlockEditerLength; ++i) {
                items.add((Object)this.getItemStackWithNBT(this, i + 1, 1));
            }
        }
    }

    private ItemStack getItemStackWithNBT(Item item, int size, int type) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("westBlockState", Block.func_176210_f((IBlockState)AsphaltModBlock.ASPHALT_BLOCK.func_176223_P()));
        nbtTagCompound.func_74768_a("eastBlockState", Block.func_176210_f((IBlockState)AsphaltModBlock.CONCRETE_BLOCK.func_176223_P()));
        nbtTagCompound.func_74768_a("size", size);
        nbtTagCompound.func_74768_a("type", type);
        nbtTagCompound.func_74757_a("setting", false);
        ItemStack itemStack = new ItemStack(item);
        itemStack.func_77982_d(nbtTagCompound);
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            int size = nbtTagCompound.func_74762_e("size");
            int type = nbtTagCompound.func_74762_e("type");
            IBlockState westBlock = Block.func_176220_d((int)nbtTagCompound.func_74762_e("westBlockState"));
            IBlockState eastBlock = Block.func_176220_d((int)nbtTagCompound.func_74762_e("eastBlockState"));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.double_material_block_editor.info.desc", (Object[])new Object[0]));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.double_material_block_editor.info.usage", (Object[])new Object[0]));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.double_material_block_editor.info.usage2", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.double_material_block_editor.info.size", (Object[])new Object[0]) + ":" + size);
            tooltip.add(I18n.func_135052_a((String)"item.double_material_block_editor.info.type", (Object[])new Object[0]) + ":" + type);
            tooltip.add(I18n.func_135052_a((String)"item.double_material_block_editor.info.block.west", (Object[])new Object[0]) + ":" + AsphaltModUtil.getItemBlockName(westBlock.func_177230_c(), westBlock.func_177230_c().func_176201_c(westBlock)));
            tooltip.add(I18n.func_135052_a((String)"item.double_material_block_editor.info.block.east", (Object[])new Object[0]) + ":" + AsphaltModUtil.getItemBlockName(eastBlock.func_177230_c(), eastBlock.func_177230_c().func_176201_c(eastBlock)));
        } else {
            tooltip.add("Data is Empty!");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            FMLClientHandler.instance().showGuiScreen((Object)new GuiDoubleMaterialBlockEditor(playerIn, handIn));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        player.field_71071_by.func_70296_d();
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77978_p() != null) {
            if (!player.func_70093_af()) {
                NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
                int size = nbtTagCompound.func_74762_e("size");
                int type = nbtTagCompound.func_74762_e("type");
                IBlockState westBlock = Block.func_176220_d((int)nbtTagCompound.func_74762_e("westBlockState"));
                IBlockState eastBlock = Block.func_176220_d((int)nbtTagCompound.func_74762_e("eastBlockState"));
                if (type == 0) {
                    this.setDmBlock(size, westBlock, eastBlock, player.func_174811_aO().func_176736_b(), worldIn, pos);
                } else {
                    this.setDmBlockReverse(size, westBlock, eastBlock, player.func_174811_aO().func_176736_b(), worldIn, pos);
                }
                return EnumActionResult.SUCCESS;
            }
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            boolean setting = nbtTagCompound.func_74767_n("setting");
            if (!setting) {
                IBlockState westBlock = worldIn.func_180495_p(pos);
                nbtTagCompound.func_74768_a("westBlockState", Block.func_176210_f((IBlockState)westBlock));
                nbtTagCompound.func_74757_a("setting", true);
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.double_material_block_editor.info.msg", (Object[])new Object[0]) + "(" + AsphaltModUtil.getItemBlockName(westBlock.func_177230_c(), westBlock.func_177230_c().func_176201_c(westBlock)) + ")"));
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.double_material_block_editor.info.msg2", (Object[])new Object[0])));
                }
            } else {
                IBlockState eastBlock = worldIn.func_180495_p(pos);
                nbtTagCompound.func_74768_a("eastBlockState", Block.func_176210_f((IBlockState)eastBlock));
                nbtTagCompound.func_74757_a("setting", false);
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.double_material_block_editor.info.msg3", (Object[])new Object[0]) + "(" + AsphaltModUtil.getItemBlockName(eastBlock.func_177230_c(), eastBlock.func_177230_c().func_176201_c(eastBlock)) + ")"));
                }
            }
            itemStack.func_77982_d(nbtTagCompound);
            player.field_71071_by.func_70296_d();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void setDmBlock(int size, IBlockState westBlockState, IBlockState eastBlockState, int facing, World world, BlockPos pos) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (facing != 0) break block4;
                        double space = 1.0 / (double)size;
                        for (int i = 0; i < size; ++i) {
                            double south = space * (double)i;
                            double north = space * (double)(i + 1);
                            this.setBlockWithData(north, south, westBlockState, eastBlockState, 2, world, pos.func_177982_a(0, 1, i));
                        }
                        break block5;
                    }
                    if (facing != 1) break block6;
                    double space = 1.0 / (double)size;
                    for (int i = 0; i < size; ++i) {
                        double south = space * (double)i;
                        double north = space * (double)(i + 1);
                        this.setBlockWithData(north, south, westBlockState, eastBlockState, 3, world, pos.func_177982_a(-i, 1, 0));
                    }
                    break block5;
                }
                if (facing != 2) break block7;
                double space = 1.0 / (double)size;
                for (int i = 0; i < size; ++i) {
                    double south = space * (double)i;
                    double north = space * (double)(i + 1);
                    this.setBlockWithData(north, south, westBlockState, eastBlockState, 0, world, pos.func_177982_a(0, 1, -i));
                }
                break block5;
            }
            if (facing != 3) break block5;
            double space = 1.0 / (double)size;
            for (int i = 0; i < size; ++i) {
                double south = space * (double)i;
                double north = space * (double)(i + 1);
                this.setBlockWithData(north, south, westBlockState, eastBlockState, 1, world, pos.func_177982_a(i, 1, 0));
            }
        }
    }

    private void setDmBlockReverse(int size, IBlockState westBlockState, IBlockState eastBlockState, int facing, World world, BlockPos pos) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (facing != 0) break block4;
                        double space = 1.0 / (double)size;
                        for (int i = 0; i < size; ++i) {
                            double south = 1.0 - space * (double)i;
                            double north = 1.0 - space * (double)(i + 1);
                            this.setBlockWithData(north, south, westBlockState, eastBlockState, 2, world, pos.func_177982_a(0, 1, i));
                        }
                        break block5;
                    }
                    if (facing != 1) break block6;
                    double space = 1.0 / (double)size;
                    for (int i = 0; i < size; ++i) {
                        double south = 1.0 - space * (double)i;
                        double north = 1.0 - space * (double)(i + 1);
                        this.setBlockWithData(north, south, westBlockState, eastBlockState, 3, world, pos.func_177982_a(-i, 1, 0));
                    }
                    break block5;
                }
                if (facing != 2) break block7;
                double space = 1.0 / (double)size;
                for (int i = 0; i < size; ++i) {
                    double south = 1.0 - space * (double)i;
                    double north = 1.0 - space * (double)(i + 1);
                    this.setBlockWithData(north, south, westBlockState, eastBlockState, 0, world, pos.func_177982_a(0, 1, -i));
                }
                break block5;
            }
            if (facing != 3) break block5;
            double space = 1.0 / (double)size;
            for (int i = 0; i < size; ++i) {
                double south = 1.0 - space * (double)i;
                double north = 1.0 - space * (double)(i + 1);
                this.setBlockWithData(north, south, westBlockState, eastBlockState, 1, world, pos.func_177982_a(i, 1, 0));
            }
        }
    }

    private void setBlockWithData(double northPosition, double southPosition, IBlockState westBlockState, IBlockState eastBlockState, int facing, World world, BlockPos pos) {
        world.func_175656_a(pos, AsphaltModBlock.DOUBLE_MATERIAL_BLOCK.func_176223_P());
        TileEntityDoubleMaterial te = (TileEntityDoubleMaterial)world.func_175625_s(pos);
        te.setBaseWestBlock(westBlockState);
        te.setBaseEastBlock(eastBlockState);
        te.northPosition = northPosition;
        te.southPosition = southPosition;
        te.direction = facing;
        te.func_70296_d();
    }
}

