/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.item;

import java.util.List;
import javax.annotation.Nullable;
import muka2533.mods.asphaltmod.AsphaltMod;
import muka2533.mods.asphaltmod.block.tileentity.TileEntityFlexibleLine;
import muka2533.mods.asphaltmod.gui.GuiFlexibleLineEditor;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModConfig;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlexibleLineEditer
extends Item {
    public ItemFlexibleLineEditer(String itemName) {
        this.setRegistryName(itemName);
        this.func_77655_b(itemName);
        this.func_77637_a(AsphaltMod.TAB_EDITOR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            int i;
            for (i = 0; i < AsphaltModConfig.flexibleLineEditerLength; ++i) {
                items.add((Object)this.getItemStackWithNBT(this, "ffffff", i + 1));
            }
            for (i = 0; i < AsphaltModConfig.flexibleLineEditerLength; ++i) {
                items.add((Object)this.getItemStackWithNBT(this, "ff7f00", i + 1));
            }
        }
    }

    private ItemStack getItemStackWithNBT(Item item, String color, int size) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74778_a("color", color);
        nbtTagCompound.func_74768_a("size", size);
        nbtTagCompound.func_74768_a("cut_front", 0);
        nbtTagCompound.func_74768_a("cut_back", 0);
        ItemStack itemStack = new ItemStack(item);
        itemStack.func_77982_d(nbtTagCompound);
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            String color = nbtTagCompound.func_74779_i("color");
            int size = nbtTagCompound.func_74762_e("size");
            int cutFront = nbtTagCompound.func_74762_e("cut_front");
            int cutBack = nbtTagCompound.func_74762_e("cut_back");
            String color_str = "";
            if (color == "ffffff") {
                color_str = "(" + I18n.func_135052_a((String)"item.flexible_line_editor.info.color.white", (Object[])new Object[0]) + ")";
            } else if (color == "ff7f00") {
                color_str = "(" + I18n.func_135052_a((String)"item.flexible_line_editor.info.color.orange", (Object[])new Object[0]) + ")";
            }
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.flexible_line_editor.info.desc", (Object[])new Object[0]));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.flexible_line_editor.info.usage", (Object[])new Object[0]));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.flexible_line_editor.info.usage2", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.flexible_line_editor.info.size", (Object[])new Object[0]) + ":" + size);
            tooltip.add(I18n.func_135052_a((String)"item.flexible_line_editor.info.color", (Object[])new Object[0]) + ":#" + color + color_str);
            tooltip.add(I18n.func_135052_a((String)"item.flexible_line_editor.info.cut.front", (Object[])new Object[0]) + ":" + cutFront);
            tooltip.add(I18n.func_135052_a((String)"item.flexible_line_editor.info.cut.back", (Object[])new Object[0]) + ":" + cutBack);
        } else {
            tooltip.add("Data is Empty!");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            FMLClientHandler.instance().showGuiScreen((Object)new GuiFlexibleLineEditor(playerIn, handIn));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        player.field_71071_by.func_70296_d();
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77978_p() != null) {
            if (!player.func_70093_af()) {
                NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
                String color = nbtTagCompound.func_74779_i("color");
                int size = nbtTagCompound.func_74762_e("size");
                int pf = player.func_174811_aO().func_176736_b();
                int cutFront = nbtTagCompound.func_74762_e("cut_front");
                int cutBack = nbtTagCompound.func_74762_e("cut_back");
                this.setFlBlock(size, color, pf, worldIn, pos, cutFront, cutBack);
                return EnumActionResult.SUCCESS;
            }
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            String color = nbtTagCompound.func_74779_i("color");
            int size = nbtTagCompound.func_74762_e("size");
            int pf = player.func_174811_aO().func_176736_b();
            int cutFront = nbtTagCompound.func_74762_e("cut_front");
            int cutBack = nbtTagCompound.func_74762_e("cut_back");
            this.setFlBlockReverse(size, color, pf, worldIn, pos, cutFront, cutBack);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void setFlBlock(int size, String color, int facing, World world, BlockPos pos, int cutFront, int cutBack) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (facing != 0) break block4;
                        double space = 1.0 / (double)size;
                        int count = 0;
                        for (int i = 0; i < size; ++i) {
                            if (i < cutFront | size - cutBack < i + 1) continue;
                            double south = space * (double)i;
                            double north = space * (double)(i + 1);
                            this.setBlockWithData(north, south, color, 2, world, pos.func_177982_a(0, 1, count));
                            ++count;
                        }
                        break block5;
                    }
                    if (facing != 1) break block6;
                    double space = 1.0 / (double)size;
                    int count = 0;
                    for (int i = 0; i < size; ++i) {
                        if (i < cutFront | size - cutBack < i + 1) continue;
                        double south = space * (double)i;
                        double north = space * (double)(i + 1);
                        this.setBlockWithData(north, south, color, 3, world, pos.func_177982_a(-count, 1, 0));
                        ++count;
                    }
                    break block5;
                }
                if (facing != 2) break block7;
                double space = 1.0 / (double)size;
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    if (i < cutFront | size - cutBack < i + 1) continue;
                    double south = space * (double)i;
                    double north = space * (double)(i + 1);
                    this.setBlockWithData(north, south, color, 0, world, pos.func_177982_a(0, 1, -count));
                    ++count;
                }
                break block5;
            }
            if (facing != 3) break block5;
            double space = 1.0 / (double)size;
            int count = 0;
            for (int i = 0; i < size; ++i) {
                if (i < cutFront | size - cutBack < i + 1) continue;
                double south = space * (double)i;
                double north = space * (double)(i + 1);
                this.setBlockWithData(north, south, color, 1, world, pos.func_177982_a(count, 1, 0));
                ++count;
            }
        }
    }

    private void setFlBlockReverse(int size, String color, int facing, World world, BlockPos pos, int cutFront, int cutBack) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (facing != 0) break block4;
                        double space = 1.0 / (double)size;
                        int count = 0;
                        for (int i = 0; i < size; ++i) {
                            if (i < cutFront | size - cutBack < i + 1) continue;
                            double south = 1.0 - space * (double)i;
                            double north = 1.0 - space * (double)(i + 1);
                            this.setBlockWithData(north, south, color, 2, world, pos.func_177982_a(0, 1, count));
                            ++count;
                        }
                        break block5;
                    }
                    if (facing != 1) break block6;
                    double space = 1.0 / (double)size;
                    int count = 0;
                    for (int i = 0; i < size; ++i) {
                        if (i < cutFront | size - cutBack < i + 1) continue;
                        double south = 1.0 - space * (double)i;
                        double north = 1.0 - space * (double)(i + 1);
                        this.setBlockWithData(north, south, color, 3, world, pos.func_177982_a(-count, 1, 0));
                        ++count;
                    }
                    break block5;
                }
                if (facing != 2) break block7;
                double space = 1.0 / (double)size;
                int count = 0;
                for (int i = 0; i < size; ++i) {
                    if (i < cutFront | size - cutBack < i + 1) continue;
                    double south = 1.0 - space * (double)i;
                    double north = 1.0 - space * (double)(i + 1);
                    this.setBlockWithData(north, south, color, 0, world, pos.func_177982_a(0, 1, -count));
                    ++count;
                }
                break block5;
            }
            if (facing != 3) break block5;
            double space = 1.0 / (double)size;
            int count = 0;
            for (int i = 0; i < size; ++i) {
                if (i < cutFront | size - cutBack < i + 1) continue;
                double south = 1.0 - space * (double)i;
                double north = 1.0 - space * (double)(i + 1);
                this.setBlockWithData(north, south, color, 1, world, pos.func_177982_a(count, 1, 0));
                ++count;
            }
        }
    }

    private void setBlockWithData(double northPosition, double southPosition, String color, int facing, World world, BlockPos pos) {
        world.func_175656_a(pos, AsphaltModBlock.FLEXIBLE_LINE.func_176223_P());
        TileEntityFlexibleLine te = (TileEntityFlexibleLine)world.func_175625_s(pos);
        te.northPosition = northPosition;
        te.southPosition = southPosition;
        te.color = color;
        te.direction = facing;
        te.func_70296_d();
    }
}

