/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.item;

import java.util.List;
import javax.annotation.Nullable;
import muka2533.mods.asphaltmod.AsphaltMod;
import muka2533.mods.asphaltmod.block.tileentity.TileEntitySlope;
import muka2533.mods.asphaltmod.gui.GuiSlopeEditer;
import muka2533.mods.asphaltmod.init.AsphaltModBlock;
import muka2533.mods.asphaltmod.init.AsphaltModConfig;
import muka2533.mods.asphaltmod.util.AsphaltModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSlopeEditer
extends Item {
    public ItemSlopeEditer(String itemName) {
        this.setRegistryName(itemName);
        this.func_77655_b(itemName);
        this.func_77637_a(AsphaltMod.TAB_EDITOR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w()) {
            ItemStack itemStack;
            NBTTagCompound nbtTagCompound;
            int i;
            for (i = 0; i < AsphaltModConfig.slopeEditorLength; ++i) {
                nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74768_a("slopeSize", i + 1);
                nbtTagCompound.func_74768_a("slopeBlockState", Block.func_176210_f((IBlockState)AsphaltModBlock.ASPHALT_BLOCK.func_176223_P()));
                nbtTagCompound.func_74757_a("slopeSteep", false);
                itemStack = new ItemStack((Item)this);
                itemStack.func_77982_d(nbtTagCompound);
                items.add((Object)itemStack);
            }
            for (i = 0; i < AsphaltModConfig.slopeEditorLength; ++i) {
                nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74768_a("slopeSize", i + 1);
                nbtTagCompound.func_74768_a("slopeBlockState", Block.func_176210_f((IBlockState)AsphaltModBlock.ASPHALT_BLOCK.func_176223_P()));
                nbtTagCompound.func_74757_a("slopeSteep", true);
                itemStack = new ItemStack((Item)this);
                itemStack.func_77982_d(nbtTagCompound);
                items.add((Object)itemStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            int slopeSize = nbtTagCompound.func_74762_e("slopeSize");
            IBlockState slopeBlockState = Block.func_176220_d((int)nbtTagCompound.func_74762_e("slopeBlockState"));
            float slopeParsentage = 1.0f / (float)slopeSize * 100.0f;
            if (nbtTagCompound.func_74767_n("slopeSteep")) {
                tooltip.add("\u00a7c" + I18n.func_135052_a((String)"item.slope_editor.info.steep", (Object[])new Object[0]));
            } else {
                tooltip.add("\u00a79" + I18n.func_135052_a((String)"item.slope_editor.info.normal", (Object[])new Object[0]));
            }
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.slope_editor.info.desc", (Object[])new Object[0]));
            tooltip.add("\u00a7e" + I18n.func_135052_a((String)"item.slope_editor.info.usage", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.slope_editor.info.size", (Object[])new Object[0]) + ":" + slopeSize + "(" + slopeParsentage + "%)");
            tooltip.add(I18n.func_135052_a((String)"item.slope_editor.info.block", (Object[])new Object[0]) + ":" + AsphaltModUtil.getItemBlockName(slopeBlockState.func_177230_c(), slopeBlockState.func_177230_c().func_176201_c(slopeBlockState)));
        } else {
            tooltip.add("Data is Empty!");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        player.field_71071_by.func_70296_d();
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77978_p() != null) {
            if (!player.func_70093_af()) {
                NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
                boolean slopeSteep = nbtTagCompound.func_74767_n("slopeSteep");
                int slopeSize = nbtTagCompound.func_74762_e("slopeSize");
                IBlockState slopeBlockState = Block.func_176220_d((int)nbtTagCompound.func_74762_e("slopeBlockState"));
                if (slopeSteep) {
                    this.setBlockWithData(slopeBlockState, player.func_174811_aO().func_176736_b(), 0.0, 1.0 * (double)slopeSize, worldIn, pos.func_177982_a(0, 1, 0));
                } else if (player.func_174811_aO() == EnumFacing.SOUTH) {
                    this.setBlockSlopeSmoothlyFacing0(slopeBlockState, slopeSize, worldIn, pos);
                } else if (player.func_174811_aO() == EnumFacing.WEST) {
                    this.setBlockSlopeSmoothlyFacing1(slopeBlockState, slopeSize, worldIn, pos);
                } else if (player.func_174811_aO() == EnumFacing.NORTH) {
                    this.setBlockSlopeSmoothlyFacing2(slopeBlockState, slopeSize, worldIn, pos);
                } else if (player.func_174811_aO() == EnumFacing.EAST) {
                    this.setBlockSlopeSmoothlyFacing3(slopeBlockState, slopeSize, worldIn, pos);
                }
                return EnumActionResult.SUCCESS;
            }
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            nbtTagCompound.func_74768_a("slopeBlockState", Block.func_176210_f((IBlockState)worldIn.func_180495_p(pos)));
            itemStack.func_77982_d(nbtTagCompound);
            if (worldIn.field_72995_K) {
                IBlockState block = worldIn.func_180495_p(pos);
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"item.slope_editor.info.msg", (Object[])new Object[0]) + "(" + AsphaltModUtil.getItemBlockName(block.func_177230_c(), block.func_177230_c().func_176201_c(block)) + ")"));
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            FMLClientHandler.instance().showGuiScreen((Object)new GuiSlopeEditer(playerIn, handIn));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    private void setBlockWithData(IBlockState state, int facing, double lowHeight, double highHeight, World world, BlockPos pos) {
        world.func_175656_a(pos, AsphaltModBlock.SLOPE_BLOCK.func_176223_P());
        TileEntitySlope te = (TileEntitySlope)world.func_175625_s(pos);
        te.setBaseBlockState(state);
        te.direction = facing;
        te.lowHeight = lowHeight;
        te.highHeight = highHeight;
        te.func_70296_d();
    }

    private void setBlockSlopeSmoothlyFacing0(IBlockState state, int length, World world, BlockPos pos) {
        double space = 1.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            double lowHeight = space * (double)i;
            double highHeight = space * (double)(i + 1);
            this.setBlockWithData(state, 2, lowHeight, highHeight, world, pos.func_177982_a(0, 1, i));
        }
    }

    private void setBlockSlopeSmoothlyFacing1(IBlockState state, int length, World world, BlockPos pos) {
        double space = 1.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            double lowHeight = space * (double)i;
            double highHeight = space * (double)(i + 1);
            this.setBlockWithData(state, 3, lowHeight, highHeight, world, pos.func_177982_a(-i, 1, 0));
        }
    }

    private void setBlockSlopeSmoothlyFacing2(IBlockState state, int length, World world, BlockPos pos) {
        double space = 1.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            double lowHeight = space * (double)i;
            double highHeight = space * (double)(i + 1);
            this.setBlockWithData(state, 0, lowHeight, highHeight, world, pos.func_177982_a(0, 1, -i));
        }
    }

    private void setBlockSlopeSmoothlyFacing3(IBlockState state, int length, World world, BlockPos pos) {
        double space = 1.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            double lowHeight = space * (double)i;
            double highHeight = space * (double)(i + 1);
            this.setBlockWithData(state, 1, lowHeight, highHeight, world, pos.func_177982_a(i, 1, 0));
        }
    }
}

