/*
 * Decompiled with CFR 0.152.
 */
package muka2533.mods.asphaltmod.signal;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import muka2533.mods.asphaltmod.signal.SignalGroup;
import net.minecraft.nbt.NBTTagCompound;

public class SignalCUCommand {
    public static final int commandWait = 0;
    public static final int commandSet = 1;
    public int command;
    public int time = 0;
    public int lightColor = 0;
    public SignalGroup signalGroup;

    public SignalCUCommand(int p_time) {
        this.command = 0;
        this.time = p_time;
    }

    public SignalCUCommand(SignalGroup p_signalGroup, int p_lightColor) {
        this.command = 1;
        this.signalGroup = p_signalGroup;
        this.lightColor = p_lightColor;
    }

    public String getCommand() {
        if (this.command == 0) {
            return this.time + "\u79d2\u5f85\u3064";
        }
        if (this.command == 1) {
            return this.signalGroup.getName() + "\u306e\u30e9\u30a4\u30c8\u306e\u8272\u3092" + this.lightColor + "\u306b\u5909\u3048\u308b";
        }
        return "\u30a8\u30e9\u30fc";
    }

    public int getCommandInt() {
        return this.command;
    }

    public int getTime() {
        return this.time;
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public SignalGroup getSignalGroup() {
        return this.signalGroup;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("SCUCommand_Command", this.command);
        if (this.command == 0) {
            nbt.func_74768_a("SCUCommand_Time", this.time);
        } else if (this.command == 1) {
            nbt.func_74768_a("SCUCommand_LightColor", this.lightColor);
            this.signalGroup.writeToNBT(nbt);
        }
    }

    public static SignalCUCommand loadSignalCUCommandFromNBT(NBTTagCompound nbt) {
        int command = nbt.func_74762_e("SCUCommand_Command");
        if (command == 0) {
            int time = nbt.func_74762_e("SCUCommand_Time");
            return new SignalCUCommand(time);
        }
        if (command == 1) {
            int lightColor = nbt.func_74762_e("SCUCommand_LightColor");
            SignalGroup signalGroup = SignalGroup.loadSignalGroupFromNBT(nbt);
            return new SignalCUCommand(signalGroup, lightColor);
        }
        return null;
    }

    public void writeToBuffer(ByteBuf buffer) throws UnsupportedEncodingException {
        buffer.writeInt(this.command);
        if (this.command == 0) {
            buffer.writeInt(this.time);
        } else if (this.command == 1) {
            buffer.writeInt(this.lightColor);
            this.signalGroup.writeToBuffer(buffer);
        }
    }

    public static SignalCUCommand loadSignalCUCommandFromBuffer(ByteBuf buffer) throws UnsupportedEncodingException {
        int command = buffer.readInt();
        if (command == 0) {
            int time = buffer.readInt();
            return new SignalCUCommand(time);
        }
        if (command == 1) {
            int lightColor = buffer.readInt();
            SignalGroup signalGroup = SignalGroup.loadSignalGroupBuffer(buffer);
            return new SignalCUCommand(signalGroup, lightColor);
        }
        return null;
    }
}

