/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.event;

import goblinbob.mobends.core.bender.EntityBender;
import goblinbob.mobends.core.bender.EntityBenderRegistry;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.mutators.Mutator;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityRenderHandler {
    @SubscribeEvent
    public void beforeLivingRender(RenderLivingEvent.Pre<? extends EntityLivingBase> event) {
        EntityLivingBase living = event.getEntity();
        EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(living);
        if (entityBender == null) {
            return;
        }
        RenderLivingBase renderer = event.getRenderer();
        float pt = event.getPartialRenderTick();
        GlStateManager.func_179094_E();
        if (entityBender.isAnimated()) {
            if (entityBender.applyMutation((RenderLivingBase<EntityLivingBase>)renderer, living, pt)) {
                Mutator<?, ?, ?> mutator = entityBender.getMutator((RenderLivingBase<EntityLivingBase>)renderer);
                Object data = mutator.getData(living);
                entityBender.beforeRender((EntityData<EntityLivingBase>)data, living, pt);
            }
        } else {
            entityBender.deapplyMutation((RenderLivingBase<EntityLivingBase>)event.getRenderer(), living);
        }
    }

    @SubscribeEvent
    public void afterLivingRender(RenderLivingEvent.Post<? extends EntityLivingBase> event) {
        EntityBender<EntityLivingBase> entityBender = EntityBenderRegistry.instance.getForEntity(event.getEntity());
        if (entityBender == null) {
            return;
        }
        entityBender.afterRender(event.getEntity(), event.getPartialRenderTick());
        GlStateManager.func_179121_F();
    }
}

