/*
 * Decompiled with CFR 0.152.
 */
package mjaroslav.mcmods.realisticbrewingstand.hook;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mjaroslav.mcmods.realisticbrewingstand.lib.ModInfo;

public class HookConfig {
    private static final String DISABLED_HOOKS_FILE = String.format("%s_disabled_hooks.txt", "realisticbrewingstand");
    private static final String COMMENT_MARK = "#";
    private static final Set<String> DISABLED_HOOKS = new HashSet<String>();
    private static final File CONFIG = new File("config");

    private static boolean hookIsEnabled(String name) {
        return !DISABLED_HOOKS.contains(name);
    }

    public static boolean vanilla() {
        return HookConfig.hookIsEnabled("hooks_vanilla");
    }

    static {
        ModInfo.LOG.info("Trying to load hooks configuration...");
        try {
            for (String line : Files.readAllLines(CONFIG.toPath().resolve(DISABLED_HOOKS_FILE))) {
                if (line.startsWith(COMMENT_MARK)) continue;
                DISABLED_HOOKS.add(line.trim().toLowerCase());
            }
            ModInfo.LOG.info(String.format("Disabled hooks: [%s]", String.join((CharSequence)", ", DISABLED_HOOKS)));
        }
        catch (IOException e) {
            ModInfo.LOG.error("Failed to load hooks configuration!", (Throwable)e);
            ModInfo.LOG.error("Trying to create default hooks configuration file...");
            String[] defaultConfiguration = new String[]{"# If you want to disable some hooks, just remove the comment mark (#) from its line.", "# Required Minecraft restart.", "# Game changes that are dependent on disabled hooks will be disabled.", COMMENT_MARK, "# hooks_vanilla"};
            try {
                if (!CONFIG.isDirectory() && !CONFIG.mkdirs()) {
                    throw new IOException("Can not create config folder");
                }
                Files.write(CONFIG.toPath().resolve(DISABLED_HOOKS_FILE), Arrays.asList(defaultConfiguration), new OpenOption[0]);
                ModInfo.LOG.info("Default hooks configuration created!");
            }
            catch (IOException ex) {
                ModInfo.LOG.error("Can not generate default hooks configuration!", (Throwable)ex);
            }
        }
    }
}

