/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.config.gui;

import com.creativemd.creativecore.common.config.gui.GuiConfigControl;
import com.creativemd.creativecore.common.config.gui.GuiConfigSubControl;
import com.creativemd.creativecore.common.config.holder.ConfigKey;
import com.creativemd.creativecore.common.config.holder.ICreativeConfigHolder;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraftforge.fml.relauncher.Side;

public class GuiConfigSubControlHolder
extends GuiConfigSubControl {
    public final ICreativeConfigHolder holder;
    public final Object value;

    public GuiConfigSubControlHolder(String name, int x, int y, int width, int height, ICreativeConfigHolder holder, Object value) {
        super(name, x, y, width, height);
        this.holder = holder;
        this.value = value;
    }

    public void createControls() {
        int offsetX = 1;
        int offsetY = 1;
        for (ConfigKey configKey : this.holder.fields()) {
            if (configKey.requiresRestart) continue;
            Object value = configKey.get();
            String caption = GuiConfigSubControlHolder.translateOrDefault("config." + String.join((CharSequence)".", this.holder.path()) + "." + configKey.name + ".name", configKey.name);
            String comment = "config." + String.join((CharSequence)".", this.holder.path()) + "." + configKey.name + ".comment";
            if (value instanceof ICreativeConfigHolder) continue;
            GuiLabel label = new GuiLabel(caption + ":", offsetX, offsetY + 2);
            final GuiConfigControl config = new GuiConfigControl((ConfigKey.ConfigKeyField)configKey, 0, offsetY, 100, 14, Side.SERVER);
            GuiButton resetButton = new GuiButton("r", offsetX + 390, offsetY, 14){

                @Override
                public void onClicked(int x, int y, int button) {
                    config.reset();
                }
            };
            int labelWidth = label.width;
            config.posX = label.posX + labelWidth + 2;
            config.width = this.width - 25 - config.posX;
            config.init(null);
            this.addControl(label.setLangTooltip(comment));
            this.addControl(config);
            this.addControl(resetButton.setCustomTooltip("reset to default"));
            config.setResetButton(resetButton);
            offsetY += config.height + 1;
        }
        this.height = offsetY;
    }

    public void save() {
        JsonObject json = new JsonObject();
        for (GuiControl control : this.controls) {
            JsonElement element;
            if (!(control instanceof GuiConfigControl) || (element = ((GuiConfigControl)control).save()) == null) continue;
            json.add(((GuiConfigControl)control).field.name, element);
        }
        this.holder.load(false, true, json, Side.SERVER);
    }
}

