/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util.files;

import com.teamacronymcoders.base.util.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class BaseFileUtils {
    public static void copyFromJar(Class<?> jarClass, String filename, File to) {
        URL url = jarClass.getResource("/assets/" + filename);
        try {
            FileUtils.copyURLToFile((URL)url, (File)to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolderContents(File directory, File zipfile) throws IOException {
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        FileOutputStream out = new FileOutputStream(zipfile);
        try (OutputStream res = out;){
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                File[] files = directory.listFiles();
                if (files == null) continue;
                for (File child : files) {
                    String name = base.relativize(child.toURI()).getPath();
                    if (child.isDirectory()) {
                        queue.push(child);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    BaseFileUtils.copy(child, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    private static void copy(File file, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            BaseFileUtils.copy(in, out);
        }
    }

    public static void safeDelete(File file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            Platform.attemptLogErrorToCurrentMod("Deleting file " + file.getAbsolutePath() + " failed.");
        }
    }

    public static void safeDeleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (Exception e) {
            Platform.attemptLogErrorToCurrentMod("Deleting directory " + file.getAbsolutePath() + " failed.");
        }
    }

    public static void createFolder(File file) {
        if (!file.exists() && !file.mkdirs()) {
            Platform.attemptLogErrorToCurrentMod("Couldn't create folder called: " + file.getName());
        }
    }

    public static String readFileToString(File file) {
        String string = null;
        try {
            string = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            Platform.attemptLogExceptionToCurrentMod(e);
        }
        return string;
    }

    public static void writeStringToFile(String string, File file) {
        boolean exists = file.exists();
        if (!exists) {
            try {
                file.getParentFile().mkdirs();
                exists = file.createNewFile();
            }
            catch (IOException e) {
                Platform.attemptLogExceptionToCurrentMod(e);
            }
        }
        if (exists) {
            try {
                FileUtils.writeStringToFile((File)file, (String)string, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                Platform.attemptLogExceptionToCurrentMod(e);
            }
        } else {
            Platform.attemptLogErrorToCurrentMod("Couldn't create File: " + file.getName());
        }
    }

    public static void createFile(File file) {
        BaseFileUtils.createFolder(file.getParentFile());
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Platform.attemptLogErrorToCurrentMod("Couldn't create File " + file.getName());
        }
    }
}

