/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.AlchemyTable")
@ZenRegister
@ModOnly(value="bloodmagic")
public class AlchemyTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, int syphon, int ticks, int minTier) {
        if (inputs.length == 0 || inputs.length > 6) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 6!");
            return;
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), syphon, ticks, minTier, InputHelper.toObjects((IIngredient[])inputs)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack[] inputs) {
        if (inputs.length == 0 || inputs.length > 6) {
            CraftTweakerAPI.logError((String)"Invalid Input Array! Maximum size is 6!");
            return;
        }
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStacks((IItemStack[])inputs)));
    }

    public static String[] getStringFromStacks(Object[] arr) {
        String[] retArr = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            retArr[i] = arr[i].toString();
        }
        return retArr;
    }

    private static class Remove
    extends BaseAction {
        private ItemStack[] inputs;

        public Remove(ItemStack[] inputs) {
            super("AlchemyTable");
            this.inputs = inputs;
        }

        public void apply() {
            BloodMagicAPI.INSTANCE.getRecipeRegistrar().removeAlchemyTable(this.inputs);
        }

        public String describe() {
            return "Removing AlchemyTable recipe for: [" + String.join((CharSequence)",", AlchemyTable.getStringFromStacks(this.inputs)) + "]";
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack output;
        private int syphon;
        private int ticks;
        private int minTier;
        private Object[] inputs;

        public Add(ItemStack output, int syphon, int ticks, int minTier, Object[] inputs) {
            super("AlchemyTable");
            this.output = output;
            this.syphon = syphon;
            this.ticks = ticks;
            this.minTier = minTier;
            this.inputs = inputs;
        }

        public void apply() {
            BloodMagicAPI.INSTANCE.getRecipeRegistrar().addAlchemyTable(this.output, this.syphon, this.ticks, this.minTier, this.inputs);
        }

        public String describe() {
            return "Adding AlchemyTable recipe for: " + this.output + " from: [" + String.join((CharSequence)",", AlchemyTable.getStringFromStacks(this.inputs)) + "] syphon: " + this.syphon + ", ticks: " + this.ticks + ", minTier: " + this.minTier;
        }
    }
}

