/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct.materials;

import com.blamejared.compat.tconstruct.actions.SetAttackAction;
import com.blamejared.compat.tconstruct.actions.SetDurabilityAction;
import com.blamejared.compat.tconstruct.actions.SetHarvestLevelAction;
import com.blamejared.compat.tconstruct.actions.SetMiningSpeedAction;
import com.blamejared.compat.tconstruct.actions.SetModifierAction;
import com.blamejared.compat.tconstruct.materials.ITICMaterial;
import com.blamejared.compat.tconstruct.materials.ITICMaterialDefinition;
import com.blamejared.compat.tconstruct.materials.TICMaterialDefinition;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class TICMaterial
implements ITICMaterial {
    private final Material material;

    public TICMaterial(Material material) {
        this.material = material;
    }

    @Override
    public String getName() {
        return this.material.getIdentifier();
    }

    @Override
    public boolean matches(ITICMaterial var1) {
        return var1.getName().equals(this.getName());
    }

    @Override
    public Object getInternal() {
        return this.material;
    }

    @Override
    public ITICMaterialDefinition getDefinition() {
        return new TICMaterialDefinition(this.material);
    }

    @Override
    public void setDurabilityHead(int durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, "head", durability));
    }

    @Override
    public int getDurabilityHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).durability;
    }

    @Override
    public void setMiningSpeedHead(float miningSpeed) {
        CraftTweakerAPI.apply((IAction)new SetMiningSpeedAction(this, "head", miningSpeed));
    }

    @Override
    public float getMiningSpeedHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).miningspeed;
    }

    @Override
    public void setAttackHead(float attack) {
        CraftTweakerAPI.apply((IAction)new SetAttackAction(this, "head", attack));
    }

    @Override
    public float getAttackHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).attack;
    }

    @Override
    public void setHarvestLevelHead(int level) {
        CraftTweakerAPI.apply((IAction)new SetHarvestLevelAction(this, "head", level));
    }

    @Override
    public int getHarvestLevelHead() {
        return ((HeadMaterialStats)this.material.getStats((String)"head")).harvestLevel;
    }

    @Override
    public void setDurabilityHandle(int durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, "handle", durability));
    }

    @Override
    public int getDurabilityHandle() {
        return ((HandleMaterialStats)this.material.getStats((String)"handle")).durability;
    }

    @Override
    public void setModifierHandle(float modifier) {
        CraftTweakerAPI.apply((IAction)new SetModifierAction(this, "handle", modifier));
    }

    @Override
    public float getModifierHandle() {
        return ((HandleMaterialStats)this.material.getStats((String)"handle")).modifier;
    }

    @Override
    public void setDurabilityExtra(int durability) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, "extra", durability));
    }

    @Override
    public int getDurabilityExtra() {
        return ((ExtraMaterialStats)this.material.getStats((String)"extra")).extraDurability;
    }

    @Override
    public void setArrowModifier(float modifier) {
        CraftTweakerAPI.apply((IAction)new SetModifierAction(this, "shaft", modifier));
    }

    @Override
    public float getArrowModifier() {
        return ((ArrowShaftMaterialStats)this.material.getStats((String)"shaft")).modifier;
    }

    @Override
    public void setArrowBonusAmmo(int bonusAmmo) {
        CraftTweakerAPI.apply((IAction)new SetDurabilityAction(this, "shaft", bonusAmmo));
    }

    @Override
    public int getArrowBonusAmmo() {
        return ((ArrowShaftMaterialStats)this.material.getStats((String)"shaft")).bonusAmmo;
    }

    @Override
    public void setFletchingModifier(float modifier) {
        CraftTweakerAPI.apply((IAction)new SetModifierAction(this, "fletching", modifier));
    }

    @Override
    public float getFletchingModifier() {
        return ((FletchingMaterialStats)this.material.getStats((String)"fletching")).modifier;
    }

    @Override
    public void setFletchingAccuracy(float accuracy) {
        CraftTweakerAPI.apply((IAction)new SetAttackAction(this, "fletching", accuracy));
    }

    @Override
    public float getFletchingAccuracy() {
        return ((FletchingMaterialStats)this.material.getStats((String)"fletching")).accuracy;
    }
}

