/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tcb.spiderstpo.common.CommonProxy;
import tcb.spiderstpo.common.Config;
import tcb.spiderstpo.common.Entities;
import tcb.spiderstpo.common.entity.mob.BetterCaveSpiderEntity;
import tcb.spiderstpo.common.entity.mob.BetterSpiderEntity;
import tcb.spiderstpo.compat.mobends.MoBendsCompat;

@Mod(modid="spiderstpo", name="Spiders 2.0", acceptedMinecraftVersions="[1.12.2]", useMetadata=true)
public class SpiderMod {
    @Mod.Instance(value="spiderstpo")
    public static SpiderMod instance;
    @SidedProxy(modId="spiderstpo", clientSide="tcb.spiderstpo.client.ClientProxy", serverSide="tcb.spiderstpo.common.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ConfigManager.sync((String)"spiderstpo", (Config.Type)Config.Type.INSTANCE);
        MinecraftForge.EVENT_BUS.register(SpiderMod.class);
        MinecraftForge.EVENT_BUS.register(Config.class);
        Entities.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        MoBendsCompat.init();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpawnEntity(LivingSpawnEvent.CheckSpawn event) {
        if (Config.replaceAnySpawns || Config.replaceNaturalSpawns) {
            Entity replacement;
            Entity entity = event.getEntity();
            if (!entity.func_130014_f_().field_72995_K && (replacement = SpiderMod.replaceSpawn(entity, true)) != null) {
                event.setResult(Event.Result.DENY);
                MobSpawnerBaseLogic spawner = event.getSpawner();
                if (spawner != null) {
                    spawner.func_190894_a(EntityList.func_191306_a(replacement.getClass()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpawnEntity(LivingSpawnEvent.SpecialSpawn event) {
        if (Config.replaceAnySpawns || Config.replaceNaturalSpawns) {
            Entity replacement;
            Entity entity = event.getEntity();
            if (!entity.func_130014_f_().field_72995_K && (replacement = SpiderMod.replaceSpawn(entity, true)) != null) {
                event.setCanceled(true);
                MobSpawnerBaseLogic spawner = event.getSpawner();
                if (spawner != null) {
                    spawner.func_190894_a(EntityList.func_191306_a(replacement.getClass()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAddEntity(EntityJoinWorldEvent event) {
        if (Config.replaceAnySpawns) {
            Entity entity = event.getEntity();
            if (!entity.func_130014_f_().field_72995_K && SpiderMod.replaceSpawn(entity, false) != null) {
                event.setCanceled(true);
            }
        }
    }

    private static Entity replaceSpawn(Entity entity, boolean newSpawn) {
        World world = entity.func_130014_f_();
        BetterSpiderEntity replacement = null;
        if (entity.getClass().equals(EntitySpider.class)) {
            replacement = new BetterSpiderEntity(world);
        } else if (entity.getClass().equals(EntityCaveSpider.class)) {
            replacement = new BetterCaveSpiderEntity(world);
        }
        if (replacement != null) {
            replacement.func_70020_e(entity.func_189511_e(new NBTTagCompound()));
            replacement.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            if (newSpawn && replacement instanceof EntityLiving) {
                ((EntityLiving)replacement).func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
            }
            ((Entity)replacement).field_98038_p = entity.field_98038_p;
            world.func_72838_d((Entity)replacement);
            return replacement;
        }
        return null;
    }
}

