/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.mob;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.tuple.Pair;
import tcb.spiderstpo.common.CollisionSmoothingUtil;
import tcb.spiderstpo.common.Config;
import tcb.spiderstpo.common.Matrix4f;
import tcb.spiderstpo.common.entity.movement.AdvancedClimberPathNavigator;
import tcb.spiderstpo.common.entity.movement.ClimberLookController;
import tcb.spiderstpo.common.entity.movement.ClimberMoveController;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public abstract class AbstractClimberEntity
extends EntityCreature
implements IAdvancedPathFindingEntity {
    public boolean pathFinderDebugPreview;
    public static final ImmutableList<DataParameter<Optional<BlockPos>>> PATHING_TARGETS = ImmutableList.of((Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k), (Object)EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187201_k));
    public static final DataParameter<Rotations> ROTATION_BODY = EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> ROTATION_HEAD = EntityDataManager.func_187226_a(AbstractClimberEntity.class, (DataSerializer)DataSerializers.field_187199_i);
    public double prevStickingOffsetX;
    public double prevStickingOffsetY;
    public double prevStickingOffsetZ;
    public double stickingOffsetX;
    public double stickingOffsetY;
    public double stickingOffsetZ;
    public Vec3d orientationNormal = new Vec3d(0.0, 1.0, 0.0);
    public Vec3d prevOrientationNormal = new Vec3d(0.0, 1.0, 0.0);
    public float prevOrientationYawDelta;
    public float orientationYawDelta;
    protected double attachedStickingOffsetX;
    protected double attachedStickingOffsetY;
    protected double attachedStickingOffsetZ;
    protected Vec3d attachedOrientationNormal = new Vec3d(0.0, 1.0, 0.0);
    protected int attachedTicks = 5;
    protected Vec3d attachedSides = new Vec3d(0.0, 0.0, 0.0);
    protected Vec3d prevAttachedSides = new Vec3d(0.0, 0.0, 0.0);
    protected boolean canClimbInWater = false;
    protected boolean canClimbInLava = false;
    protected boolean isTravelingInFluid = false;
    protected float collisionsInclusionRange = 2.0f;
    protected float collisionsSmoothingRange = 1.25f;

    public AbstractClimberEntity(World world) {
        super(world);
        this.field_70138_W = 0.1f;
        this.field_70765_h = new ClimberMoveController(this);
        this.field_70749_g = new ClimberLookController(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.pathFinderDebugPreview = Config.pathFinderDebugPreview;
        if (this.pathFinderDebugPreview) {
            for (DataParameter pathingTarget : PATHING_TARGETS) {
                this.field_70180_af.func_187214_a(pathingTarget, (Object)Optional.absent());
            }
        }
        this.field_70180_af.func_187214_a(ROTATION_BODY, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        this.field_70180_af.func_187214_a(ROTATION_HEAD, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        AdvancedClimberPathNavigator<AbstractClimberEntity> navigate = new AdvancedClimberPathNavigator<AbstractClimberEntity>(this, worldIn, false, true, true);
        navigate.func_179693_d(true);
        return navigate;
    }

    @Override
    public float getBridgePathingMalus(EntityLiving entity, BlockPos pos, PathPoint fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(EnumFacing facing) {
    }

    public int func_82143_as() {
        return 0;
    }

    public float getMovementSpeed() {
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        return attribute != null ? (float)attribute.func_111126_e() : 1.0f;
    }

    private static double calculateXOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetX) {
        if (other.field_72337_e > aabb.field_72338_b && other.field_72338_b < aabb.field_72337_e && other.field_72334_f > aabb.field_72339_c && other.field_72339_c < aabb.field_72334_f) {
            double dx;
            if (offsetX > 0.0 && other.field_72336_d <= aabb.field_72340_a) {
                double dx2 = aabb.field_72340_a - other.field_72336_d;
                if (dx2 < offsetX) {
                    offsetX = dx2;
                }
            } else if (offsetX < 0.0 && other.field_72340_a >= aabb.field_72336_d && (dx = aabb.field_72336_d - other.field_72340_a) > offsetX) {
                offsetX = dx;
            }
            return offsetX;
        }
        return offsetX;
    }

    private static double calculateYOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetY) {
        if (other.field_72336_d > aabb.field_72340_a && other.field_72340_a < aabb.field_72336_d && other.field_72334_f > aabb.field_72339_c && other.field_72339_c < aabb.field_72334_f) {
            double dy;
            if (offsetY > 0.0 && other.field_72337_e <= aabb.field_72338_b) {
                double dy2 = aabb.field_72338_b - other.field_72337_e;
                if (dy2 < offsetY) {
                    offsetY = dy2;
                }
            } else if (offsetY < 0.0 && other.field_72338_b >= aabb.field_72337_e && (dy = aabb.field_72337_e - other.field_72338_b) > offsetY) {
                offsetY = dy;
            }
            return offsetY;
        }
        return offsetY;
    }

    private static double calculateZOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetZ) {
        if (other.field_72336_d > aabb.field_72340_a && other.field_72340_a < aabb.field_72336_d && other.field_72337_e > aabb.field_72338_b && other.field_72338_b < aabb.field_72337_e) {
            double dz;
            if (offsetZ > 0.0 && other.field_72334_f <= aabb.field_72339_c) {
                double dz2 = aabb.field_72339_c - other.field_72334_f;
                if (dz2 < offsetZ) {
                    offsetZ = dz2;
                }
            } else if (offsetZ < 0.0 && other.field_72339_c >= aabb.field_72334_f && (dz = aabb.field_72334_f - other.field_72339_c) > offsetZ) {
                offsetZ = dz;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    public Pair<EnumFacing, Vec3d> getWalkingSide() {
        Object avoidPathingFacing = null;
        AxisAlignedBB entityBox = this.func_174813_aQ();
        double closestFacingDst = Double.MAX_VALUE;
        EnumFacing closestFacing = null;
        Vec3d weighting = new Vec3d(0.0, 0.0, 0.0);
        float stickingDistance = this.field_191988_bg != 0.0f ? 1.5f : 0.1f;
        for (EnumFacing facing : EnumFacing.values()) {
            if (avoidPathingFacing == facing) continue;
            List collisionBoxes = this.field_70170_p.func_184144_a((Entity)this, entityBox.func_186662_g((double)0.2f).func_72321_a((double)((float)facing.func_82601_c() * stickingDistance), (double)((float)facing.func_96559_d() * stickingDistance), (double)((float)facing.func_82599_e() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (AxisAlignedBB collisionBox : collisionBoxes) {
                switch (facing) {
                    case EAST: 
                    case WEST: {
                        closestDst = Math.min(closestDst, Math.abs(AbstractClimberEntity.calculateXOffset(entityBox, collisionBox, (float)(-facing.func_82601_c()) * stickingDistance)));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        closestDst = Math.min(closestDst, Math.abs(AbstractClimberEntity.calculateYOffset(entityBox, collisionBox, (float)(-facing.func_96559_d()) * stickingDistance)));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        closestDst = Math.min(closestDst, Math.abs(AbstractClimberEntity.calculateZOffset(entityBox, collisionBox, (float)(-facing.func_82599_e()) * stickingDistance)));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.func_178787_e(new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e()).func_186678_a(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        if (closestFacing == null) {
            return Pair.of((Object)EnumFacing.DOWN, (Object)new Vec3d(0.0, -1.0, 0.0));
        }
        return Pair.of(closestFacing, (Object)weighting.func_72432_b().func_72441_c(0.0, (double)-0.001f, 0.0).func_72432_b());
    }

    public Orientation getOrientation(float partialTicks) {
        Vec3d orientationNormal = this.prevOrientationNormal.func_178787_e(this.orientationNormal.func_178788_d(this.prevOrientationNormal).func_186678_a((double)partialTicks));
        Vec3d localZ = new Vec3d(0.0, 0.0, 1.0);
        Vec3d localY = new Vec3d(0.0, 1.0, 0.0);
        Vec3d localX = new Vec3d(1.0, 0.0, 0.0);
        float componentZ = (float)localZ.func_72430_b(orientationNormal);
        float componentX = (float)localX.func_72430_b(orientationNormal);
        float yaw = (float)Math.toDegrees(Math.atan2(componentX, componentZ));
        localZ = new Vec3d(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        localY = new Vec3d(0.0, 1.0, 0.0);
        localX = new Vec3d(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        componentZ = (float)localZ.func_72430_b(orientationNormal);
        float componentY = (float)localY.func_72430_b(orientationNormal);
        componentX = (float)localX.func_72430_b(orientationNormal);
        float pitch = (float)Math.toDegrees(Math.atan2(MathHelper.func_76129_c((float)(componentX * componentX + componentZ * componentZ)), componentY));
        Matrix4f m = new Matrix4f();
        m.multiply(new Matrix4f((float)Math.toRadians(yaw), 0.0f, 1.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(pitch), 1.0f, 0.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(Math.signum(0.5f - componentY - componentZ - componentX) * yaw), 0.0f, 1.0f, 0.0f));
        localZ = m.multiply(new Vec3d(0.0, 0.0, -1.0));
        localY = m.multiply(new Vec3d(0.0, 1.0, 0.0));
        localX = m.multiply(new Vec3d(1.0, 0.0, 0.0));
        return new Orientation(orientationNormal, localZ, localY, localX, componentZ, componentY, componentX, yaw, pitch);
    }

    public void func_70071_h_() {
        block7: {
            EntityTrackerEntry tracker;
            super.func_70071_h_();
            if (this.field_70170_p.field_72995_K || !(this.field_70170_p instanceof WorldServer) || (tracker = (EntityTrackerEntry)((WorldServer)this.field_70170_p).func_73039_n().field_72794_c.func_76041_a(this.func_145782_y())) == null || tracker.field_73136_m % tracker.field_73131_c != 0) break block7;
            Vec3d look = this.getOrientation(1.0f).getDirection(this.field_70177_z, this.field_70125_A);
            this.field_70180_af.func_187227_b(ROTATION_BODY, (Object)new Rotations((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c));
            look = this.getOrientation(1.0f).getDirection(this.field_70759_as, 0.0f);
            this.field_70180_af.func_187227_b(ROTATION_HEAD, (Object)new Rotations((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c));
            if (this.pathFinderDebugPreview) {
                Path path = this.func_70661_as().func_75505_d();
                if (path != null) {
                    int i = 0;
                    for (DataParameter pathingTarget : PATHING_TARGETS) {
                        if (path.func_75873_e() + i < path.func_75874_d()) {
                            PathPoint point = path.func_75877_a(path.func_75873_e() + i);
                            this.field_70180_af.func_187227_b(pathingTarget, (Object)Optional.of((Object)new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)));
                        } else {
                            this.field_70180_af.func_187227_b(pathingTarget, (Object)Optional.absent());
                        }
                        ++i;
                    }
                } else {
                    for (DataParameter pathingTarget : PATHING_TARGETS) {
                        this.field_70180_af.func_187227_b(pathingTarget, (Object)Optional.absent());
                    }
                }
            }
        }
    }

    @Nullable
    public BlockPos getPathingTarget(int i) {
        if (this.pathFinderDebugPreview) {
            return (BlockPos)((Optional)this.field_70180_af.func_187225_a((DataParameter)PATHING_TARGETS.get(i))).orNull();
        }
        return null;
    }

    public float getVerticalOffset(float partialTicks) {
        return 0.45f;
    }

    protected void updateOffsetsAndOrientation() {
        Vec3d direction = this.getOrientation(1.0f).getDirection(this.field_70177_z, this.field_70125_A);
        boolean isAttached = false;
        double baseStickingOffsetX = 0.0;
        double baseStickingOffsetY = this.getVerticalOffset(1.0f);
        double baseStickingOffsetZ = 0.0;
        Vec3d baseOrientationNormal = new Vec3d(0.0, 1.0, 0.0);
        if (!this.isTravelingInFluid && this.field_70122_E && this.func_184187_bx() == null) {
            Vec3d p = this.func_174791_d();
            Vec3d s = p.func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0);
            AxisAlignedBB inclusionBox = new AxisAlignedBB(s.field_72450_a, s.field_72448_b, s.field_72449_c, s.field_72450_a, s.field_72448_b, s.field_72449_c).func_186662_g((double)this.collisionsInclusionRange);
            List boxes = this.field_70170_p.func_184144_a((Entity)this, inclusionBox);
            Pair<Vec3d, Vec3d> attachmentPoint = CollisionSmoothingUtil.findClosestPoint(boxes, this.collisionsSmoothingRange, 1.0f, 0.005f, 20, 0.05f, s);
            if (attachmentPoint != null) {
                isAttached = true;
                this.attachedStickingOffsetX = MathHelper.func_151237_a((double)(((Vec3d)attachmentPoint.getLeft()).field_72450_a - p.field_72450_a), (double)(-this.field_70130_N / 2.0f), (double)(this.field_70130_N / 2.0f));
                this.attachedStickingOffsetY = MathHelper.func_151237_a((double)(((Vec3d)attachmentPoint.getLeft()).field_72448_b - p.field_72448_b), (double)0.0, (double)this.field_70131_O);
                this.attachedStickingOffsetZ = MathHelper.func_151237_a((double)(((Vec3d)attachmentPoint.getLeft()).field_72449_c - p.field_72449_c), (double)(-this.field_70130_N / 2.0f), (double)(this.field_70130_N / 2.0f));
                this.attachedOrientationNormal = (Vec3d)attachmentPoint.getRight();
            }
        }
        this.prevStickingOffsetX = this.stickingOffsetX;
        this.prevStickingOffsetY = this.stickingOffsetY;
        this.prevStickingOffsetZ = this.stickingOffsetZ;
        this.prevOrientationNormal = this.orientationNormal;
        float attachmentBlend = (float)this.attachedTicks * 0.2f;
        this.stickingOffsetX = baseStickingOffsetX + (this.attachedStickingOffsetX - baseStickingOffsetX) * (double)attachmentBlend;
        this.stickingOffsetY = baseStickingOffsetY + (this.attachedStickingOffsetY - baseStickingOffsetY) * (double)attachmentBlend;
        this.stickingOffsetZ = baseStickingOffsetZ + (this.attachedStickingOffsetZ - baseStickingOffsetZ) * (double)attachmentBlend;
        this.orientationNormal = baseOrientationNormal.func_178787_e(this.attachedOrientationNormal.func_178788_d(baseOrientationNormal).func_186678_a((double)attachmentBlend)).func_72432_b();
        this.attachedTicks = !isAttached ? Math.max(0, this.attachedTicks - 1) : Math.min(5, this.attachedTicks + 1);
        Pair<Float, Float> newRotations = this.getOrientation(1.0f).getRotation(direction);
        float yawDelta = ((Float)newRotations.getLeft()).floatValue() - this.field_70177_z;
        float pitchDelta = ((Float)newRotations.getRight()).floatValue() - this.field_70125_A;
        this.prevOrientationYawDelta = this.orientationYawDelta;
        this.orientationYawDelta = yawDelta;
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + yawDelta));
        this.field_70126_B = this.wrapAngleInRange(this.field_70126_B, this.field_70177_z);
        this.field_184626_bk = MathHelper.func_76138_g((double)(this.field_184626_bk + (double)yawDelta));
        this.field_70761_aq = MathHelper.func_76142_g((float)(this.field_70761_aq + yawDelta));
        this.field_70760_ar = this.wrapAngleInRange(this.field_70760_ar, this.field_70761_aq);
        this.field_70759_as = MathHelper.func_76142_g((float)(this.field_70759_as + yawDelta));
        this.field_70758_at = this.wrapAngleInRange(this.field_70758_at, this.field_70759_as);
        this.field_70125_A = MathHelper.func_76142_g((float)(this.field_70125_A + pitchDelta));
        this.field_70127_C = this.wrapAngleInRange(this.field_70127_C, this.field_70125_A);
        this.field_70709_bj = MathHelper.func_76138_g((double)(this.field_70709_bj + (double)pitchDelta));
    }

    private float wrapAngleInRange(float angle, float target) {
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.func_180426_a(x, y, z, (float)this.field_184626_bk, (float)this.field_70709_bj, posRotationIncrements, teleport);
    }

    public void func_70034_d(float rotation) {
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (ROTATION_BODY.equals(key)) {
            Rotations rotation = (Rotations)this.field_70180_af.func_187225_a(ROTATION_BODY);
            Vec3d look = new Vec3d((double)rotation.func_179415_b(), (double)rotation.func_179416_c(), (double)rotation.func_179413_d());
            Pair<Float, Float> rotations = this.getOrientation(1.0f).getRotation(look);
            this.field_184626_bk = ((Float)rotations.getLeft()).floatValue();
            this.field_70709_bj = ((Float)rotations.getRight()).floatValue();
        } else if (ROTATION_HEAD.equals(key)) {
            Rotations rotation = (Rotations)this.field_70180_af.func_187225_a(ROTATION_HEAD);
            Vec3d look = new Vec3d((double)rotation.func_179415_b(), (double)rotation.func_179416_c(), (double)rotation.func_179413_d());
            Pair<Float, Float> rotations = this.getOrientation(1.0f).getRotation(look);
            this.field_70759_as = ((Float)rotations.getLeft()).floatValue();
        }
    }

    public Vec3d getStickingForce(Pair<EnumFacing, Vec3d> walkingSide) {
        if (!this.func_189652_ae()) {
            return ((Vec3d)walkingSide.getRight()).func_186678_a((double)0.08f);
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        boolean canTravel = this.func_70613_aW() || this.func_184186_bw();
        this.isTravelingInFluid = false;
        if (!this.canClimbInWater && this.func_70090_H()) {
            this.isTravelingInFluid = true;
            if (canTravel) {
                super.func_191986_a(strafe, vertical, forward);
            }
        } else if (!this.canClimbInLava && this.func_180799_ab()) {
            this.isTravelingInFluid = true;
            if (canTravel) {
                super.func_191986_a(strafe, vertical, forward);
            }
        } else if (canTravel) {
            this.travelOnGround(strafe, vertical, forward);
        }
        if (!canTravel) {
            this.updateLimbSwing((EntityLiving)this, true);
        }
        this.updateOffsetsAndOrientation();
    }

    protected void travelOnGround(float strafe, float vertical, float forward) {
        boolean detachedZ;
        Orientation orientation = this.getOrientation(1.0f);
        Vec3d forwardVector = orientation.getDirection(this.field_70177_z, 0.0f);
        Vec3d upVector = orientation.getDirection(this.field_70177_z, -90.0f);
        Pair<EnumFacing, Vec3d> walkingSide = this.getWalkingSide();
        Vec3d stickingForce = this.getStickingForce(walkingSide);
        if (forward != 0.0f) {
            float slipperiness = 0.91f;
            if (this.field_70122_E) {
                BlockPos offsetPos = new BlockPos(this.func_174791_d()).func_177972_a((EnumFacing)walkingSide.getLeft());
                IBlockState offsetState = this.field_70170_p.func_180495_p(offsetPos);
                slipperiness = offsetState.func_177230_c().getSlipperiness(offsetState, (IBlockAccess)this.field_70170_p, offsetPos, (Entity)this) * 0.91f;
            }
            float friction = forward * 0.16277136f / (slipperiness * slipperiness * slipperiness);
            float f = forward * forward;
            if (f >= 1.0E-4f) {
                boolean isInnerCorner;
                f = Math.max(MathHelper.func_76129_c((float)f), 1.0f);
                f = friction / f;
                Vec3d forwardOffset = new Vec3d(forwardVector.field_72450_a * (double)forward * (double)f, forwardVector.field_72448_b * (double)forward * (double)f, forwardVector.field_72449_c * (double)forward * (double)f);
                double px = this.field_70165_t;
                double py = this.field_70163_u;
                double pz = this.field_70161_v;
                Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                AxisAlignedBB aabb = this.func_174813_aQ();
                this.func_70091_d(MoverType.SELF, forwardOffset.field_72450_a, forwardOffset.field_72448_b, forwardOffset.field_72449_c);
                Vec3d movementDir = new Vec3d(this.field_70165_t - px, this.field_70163_u - py, this.field_70161_v - pz).func_72432_b();
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
                Vec3d probeVector = new Vec3d(Math.abs(movementDir.field_72450_a) < 0.001 ? -Math.signum(upVector.field_72450_a) : 0.0, Math.abs(movementDir.field_72448_b) < 0.001 ? -Math.signum(upVector.field_72448_b) : 0.0, Math.abs(movementDir.field_72449_c) < 0.001 ? -Math.signum(upVector.field_72449_c) : 0.0).func_72432_b().func_186678_a(1.0E-4);
                this.func_70091_d(MoverType.SELF, probeVector.field_72450_a, probeVector.field_72448_b, probeVector.field_72449_c);
                Vec3d collisionNormal = new Vec3d(Math.abs(this.field_70165_t - px - probeVector.field_72450_a) > 1.0E-6 ? Math.signum(-probeVector.field_72450_a) : 0.0, Math.abs(this.field_70163_u - py - probeVector.field_72448_b) > 1.0E-6 ? Math.signum(-probeVector.field_72448_b) : 0.0, Math.abs(this.field_70161_v - pz - probeVector.field_72449_c) > 1.0E-6 ? Math.signum(-probeVector.field_72449_c) : 0.0).func_72432_b();
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
                Vec3d surfaceMovementDir = movementDir.func_178788_d(collisionNormal.func_186678_a(collisionNormal.func_72430_b(movementDir))).func_72432_b();
                boolean bl = isInnerCorner = Math.abs(collisionNormal.field_72450_a) + Math.abs(collisionNormal.field_72448_b) + Math.abs(collisionNormal.field_72449_c) > (double)1.0001f;
                if (!isInnerCorner) {
                    movementDir = surfaceMovementDir;
                }
                stickingForce = stickingForce.func_178788_d(surfaceMovementDir.func_186678_a(surfaceMovementDir.func_72432_b().func_72430_b(stickingForce)));
                float moveSpeed = forward * f;
                this.field_70159_w += movementDir.field_72450_a * (double)moveSpeed;
                this.field_70181_x += movementDir.field_72448_b * (double)moveSpeed;
                this.field_70179_y += movementDir.field_72449_c * (double)moveSpeed;
            }
        }
        double px = this.field_70165_t;
        double py = this.field_70163_u;
        double pz = this.field_70161_v;
        Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70091_d(MoverType.SELF, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        this.field_70159_w += stickingForce.field_72450_a;
        this.field_70181_x += stickingForce.field_72448_b;
        this.field_70179_y += stickingForce.field_72449_c;
        this.prevAttachedSides = this.attachedSides;
        this.attachedSides = new Vec3d(Math.abs(this.field_70165_t - px - motion.field_72450_a) > 0.001 ? -Math.signum(motion.field_72450_a) : 0.0, Math.abs(this.field_70163_u - py - motion.field_72448_b) > 0.001 ? -Math.signum(motion.field_72448_b) : 0.0, Math.abs(this.field_70161_v - pz - motion.field_72449_c) > 0.001 ? -Math.signum(motion.field_72449_c) : 0.0);
        float slipperiness = 0.91f;
        if (this.field_70122_E) {
            this.field_70143_R = 0.0f;
            BlockPos offsetPos = new BlockPos(this.func_174791_d()).func_177972_a((EnumFacing)walkingSide.getLeft());
            IBlockState offsetState = this.field_70170_p.func_180495_p(offsetPos);
            slipperiness = offsetState.func_177230_c().getSlipperiness(offsetState, (IBlockAccess)this.field_70170_p, offsetPos, (Entity)this) * 0.91f;
        }
        motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Vec3d orthogonalMotion = upVector.func_186678_a(upVector.func_72430_b(motion));
        Vec3d tangentialMotion = motion.func_178788_d(orthogonalMotion);
        this.field_70159_w = tangentialMotion.field_72450_a * (double)slipperiness + orthogonalMotion.field_72450_a * (double)0.98f;
        this.field_70181_x = tangentialMotion.field_72448_b * (double)slipperiness + orthogonalMotion.field_72448_b * (double)0.98f;
        this.field_70179_y = tangentialMotion.field_72449_c * (double)slipperiness + orthogonalMotion.field_72449_c * (double)0.98f;
        boolean detachedX = this.attachedSides.field_72450_a != this.prevAttachedSides.field_72450_a && Math.abs(this.attachedSides.field_72450_a) < 0.001;
        boolean detachedY = this.attachedSides.field_72448_b != this.prevAttachedSides.field_72448_b && Math.abs(this.attachedSides.field_72448_b) < 0.001;
        boolean bl = detachedZ = this.attachedSides.field_72449_c != this.prevAttachedSides.field_72449_c && Math.abs(this.attachedSides.field_72449_c) < 0.001;
        if (detachedX || detachedY || detachedZ) {
            float stepHeight = this.field_70138_W;
            this.field_70138_W = 0.0f;
            boolean prevOnGround = this.field_70122_E;
            boolean prevCollidedHorizontally = this.field_70123_F;
            boolean prevCollidedVertically = this.field_70124_G;
            this.func_70091_d(MoverType.SELF, detachedX ? -this.prevAttachedSides.field_72450_a * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.field_72448_b * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.field_72449_c * 0.25 : 0.0);
            Vec3d axis = this.prevAttachedSides.func_72432_b();
            Vec3d attachVector = upVector.func_186678_a(-1.0);
            attachVector = attachVector.func_178788_d(axis.func_186678_a(axis.func_72430_b(attachVector)));
            attachVector = Math.abs(attachVector.field_72450_a) > Math.abs(attachVector.field_72448_b) && Math.abs(attachVector.field_72450_a) > Math.abs(attachVector.field_72449_c) ? new Vec3d(Math.signum(attachVector.field_72450_a), 0.0, 0.0) : (Math.abs(attachVector.field_72448_b) > Math.abs(attachVector.field_72449_c) ? new Vec3d(0.0, Math.signum(attachVector.field_72448_b), 0.0) : new Vec3d(0.0, 0.0, Math.signum(attachVector.field_72449_c)));
            double attachDst = motion.func_72433_c() + (double)0.1f;
            AxisAlignedBB aabb = this.func_174813_aQ();
            motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            for (int i = 0; i < 2 && !this.field_70122_E; ++i) {
                this.func_70091_d(MoverType.SELF, attachVector.field_72450_a * attachDst, attachVector.field_72448_b * attachDst, attachVector.field_72449_c * attachDst);
            }
            this.field_70138_W = stepHeight;
            if (!this.field_70122_E) {
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
                this.field_70122_E = prevOnGround;
                this.field_70123_F = prevCollidedHorizontally;
                this.field_70124_G = prevCollidedVertically;
                this.field_70132_H = this.field_70123_F || this.field_70124_G;
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        this.updateLimbSwing((EntityLiving)this, true);
    }

    public void updateLimbSwing(EntityLiving entity, boolean includeY) {
        this.field_184618_aE = this.field_70721_aZ;
        double dx = this.field_70165_t - this.field_70169_q;
        double dy = this.field_70163_u - this.field_70167_r;
        double dz = this.field_70161_v - this.field_70166_s;
        float f = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz)) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.field_70721_aZ += (f - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        double py = this.field_70163_u;
        super.func_70091_d(type, x, y, z);
        if (Math.abs(this.field_70163_u - py - y) > 1.0E-6) {
            this.field_70181_x = 0.0;
        }
        this.field_70122_E |= this.field_70123_F || this.field_70124_G;
    }

    public static class Orientation {
        public final Vec3d normal;
        public final Vec3d localZ;
        public final Vec3d localY;
        public final Vec3d localX;
        public final float componentZ;
        public final float componentY;
        public final float componentX;
        public final float yaw;
        public final float pitch;

        private Orientation(Vec3d normal, Vec3d localZ, Vec3d localY, Vec3d localX, float componentZ, float componentY, float componentX, float yaw, float pitch) {
            this.normal = normal;
            this.localZ = localZ;
            this.localY = localY;
            this.localX = localX;
            this.componentZ = componentZ;
            this.componentY = componentY;
            this.componentX = componentX;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public Vec3d getDirection(Vec3d local) {
            return this.localX.func_186678_a(local.field_72450_a).func_178787_e(this.localY.func_186678_a(local.field_72448_b)).func_178787_e(this.localZ.func_186678_a(local.field_72449_c));
        }

        public Vec3d getDirection(float yaw, float pitch) {
            float cy = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180)));
            float sy = MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180)));
            float cp = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
            float sp = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
            return this.localX.func_186678_a((double)(sy * cp)).func_178787_e(this.localY.func_186678_a((double)sp)).func_178787_e(this.localZ.func_186678_a((double)(cy * cp)));
        }

        public Vec3d getLocal(Vec3d global) {
            return new Vec3d(this.localX.func_72430_b(global), this.localY.func_72430_b(global), this.localZ.func_72430_b(global));
        }

        public Pair<Float, Float> getRotation(Vec3d global) {
            Vec3d local = this.getLocal(global);
            float yaw = (float)Math.toDegrees(Math.atan2(local.field_72450_a, local.field_72449_c)) + 180.0f;
            float pitch = (float)(-Math.toDegrees(Math.atan2(local.field_72448_b, MathHelper.func_76133_a((double)(local.field_72450_a * local.field_72450_a + local.field_72449_c * local.field_72449_c)))));
            return Pair.of((Object)Float.valueOf(yaw), (Object)Float.valueOf(pitch));
        }
    }
}

