/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.mob;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import tcb.spiderstpo.common.entity.mob.AbstractClimberEntity;

public class BetterSpiderEntity
extends AbstractClimberEntity
implements IMob {
    public BetterSpiderEntity(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_70105_a(0.95f, 0.85f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, new AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return I18n.func_74838_a((String)"entity.Spider.name");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.func_180431_b(source) ? false : super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean success;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int kbModifier = 0;
        if (entityIn instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            kbModifier += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (success = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            int fireAspect;
            if (kbModifier > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)kbModifier * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(fireAspect * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack usingItem;
                EntityPlayer player = (EntityPlayer)entityIn;
                ItemStack heldItem = this.func_184614_ca();
                ItemStack itemStack = usingItem = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                if (!heldItem.func_190926_b() && !usingItem.func_190926_b() && heldItem.func_77973_b().canDisableShield(heldItem, usingItem, (EntityLivingBase)player, (EntityLivingBase)this) && usingItem.func_77973_b().isShield(usingItem, (EntityLivingBase)player)) {
                    float disableChance = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < disableChance) {
                        player.func_184811_cZ().func_185145_a(usingItem.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return success;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int lightLevel = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int skyLight = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            lightLevel = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(skyLight);
        }
        return lightLevel <= this.field_70146_Z.nextInt(8);
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186435_q;
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        Potion potion;
        data = super.func_180482_a(difficulty, data);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeleton skeleton = new EntitySkeleton(this.field_70170_p);
            skeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            skeleton.func_180482_a(difficulty, (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)skeleton);
            skeleton.func_184220_m((Entity)this);
        }
        if (data == null) {
            data = new EntitySpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntitySpider.GroupData)data).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (data instanceof EntitySpider.GroupData && (potion = ((EntitySpider.GroupData)data).field_188478_a) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return data;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    static class AISpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AISpiderTarget(BetterSpiderEntity spider, Class<T> classTarget) {
            super((EntityCreature)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            float brightness = this.field_75299_d.func_70013_c();
            return brightness >= 0.5f ? false : super.func_75250_a();
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(BetterSpiderEntity spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            float brightness = this.field_75441_b.func_70013_c();
            if (brightness >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

