/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;
import tcb.spiderstpo.common.entity.movement.CustomPathFinder;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public class AdvancedGroundPathNavigator<T extends EntityLiving>
extends PathNavigateGround {
    protected CustomPathFinder field_179681_j;
    protected long field_188563_q;
    protected BlockPos field_188564_r;
    protected final T obstructionAwareEntity;
    protected final boolean checkObstructions;
    protected int stuckCheckTicks = 0;

    public AdvancedGroundPathNavigator(T entity, World worldIn) {
        this(entity, worldIn, true);
    }

    public AdvancedGroundPathNavigator(T entity, World worldIn, boolean checkObstructions) {
        super(entity, worldIn);
        this.obstructionAwareEntity = entity;
        this.checkObstructions = checkObstructions;
        if (this.field_179695_a instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.field_179695_a;
            processor.setObstructionAwareEntity(entity);
            processor.setCheckObstructions(checkObstructions);
        }
    }

    public CustomPathFinder getAssignedPathFinder() {
        return this.field_179681_j;
    }

    protected final PathFinder func_179679_a() {
        this.field_179681_j = this.createPathFinder();
        this.field_179695_a = this.field_179681_j.getNodeProcessor();
        return this.field_179681_j;
    }

    protected CustomPathFinder createPathFinder() {
        AdvancedWalkNodeProcessor nodeProcessor = new AdvancedWalkNodeProcessor();
        nodeProcessor.func_186317_a(true);
        return new CustomPathFinder((NodeProcessor)nodeProcessor);
    }

    public Path func_179680_a(BlockPos pos) {
        return super.func_179680_a(pos.func_177982_a(-MathHelper.func_76123_f((float)this.field_75515_a.field_70130_N) + 1, -MathHelper.func_76123_f((float)this.field_75515_a.field_70131_O) + 1, -MathHelper.func_76123_f((float)this.field_75515_a.field_70130_N) + 1));
    }

    public void func_188554_j() {
        if (this.field_75513_b.func_82737_E() - this.field_188563_q > 20L) {
            if (this.field_188564_r != null) {
                this.field_75514_c = null;
                this.field_75514_c = this.func_179680_a(this.field_188564_r);
                this.field_188563_q = this.field_75513_b.func_82737_E();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    protected void func_179677_a(Vec3d entityPos) {
        super.func_179677_a(entityPos);
        if (this.checkObstructions && this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d checkPos;
            Vec3d target = this.field_75514_c.func_75881_a(this.obstructionAwareEntity, Math.min(this.field_75514_c.func_75874_d() - 1, this.field_75514_c.func_75873_e() + 0));
            Vec3d diff = target.func_178788_d(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d;
                switch (i) {
                    default: {
                        d = Math.abs(diff.field_72450_a);
                        break;
                    }
                    case 1: {
                        d = Math.abs(diff.field_72448_b);
                        break;
                    }
                    case 2: {
                        d = Math.abs(diff.field_72449_c);
                    }
                }
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = MathHelper.func_76141_d((float)(((EntityLiving)this.obstructionAwareEntity).field_70131_O + 1.0f));
            int ceilHalfWidth = MathHelper.func_76123_f((float)(((EntityLiving)this.obstructionAwareEntity).field_70130_N / 2.0f + 0.05f));
            switch (axis) {
                default: {
                    checkPos = new Vec3d(entityPos.field_72450_a + Math.signum(diff.field_72450_a) * (double)ceilHalfWidth, entityPos.field_72448_b, target.field_72449_c);
                    break;
                }
                case 1: {
                    checkPos = new Vec3d(entityPos.field_72450_a, entityPos.field_72448_b + (double)(diff.field_72448_b > 0.0 ? height + 1 : -1), target.field_72449_c);
                    break;
                }
                case 2: {
                    checkPos = new Vec3d(target.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c + Math.signum(diff.field_72449_c) * (double)ceilHalfWidth);
                }
            }
            Vec3d facingDiff = checkPos.func_178788_d(entityPos.func_72441_c(0.0, axis == 1 ? (double)(this.field_75515_a.field_70131_O / 2.0f) : 0.0, 0.0));
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)facingDiff.field_72450_a), (float)((float)facingDiff.field_72448_b), (float)((float)facingDiff.field_72449_c));
            boolean blocked = false;
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    AxisAlignedBB collisionBox;
                    PathNodeType nodeType;
                    BlockPos pos = new BlockPos(checkPos.field_72450_a + (double)(axis != 0 ? xzo : 0), checkPos.field_72448_b + (double)(axis != 1 ? yo : 0), checkPos.field_72449_c + (double)(axis != 2 ? xzo : 0));
                    IBlockState state = ((EntityLiving)this.obstructionAwareEntity).field_70170_p.func_180495_p(pos);
                    PathNodeType pathNodeType = nodeType = state.func_177230_c().func_176205_b((IBlockAccess)((EntityLiving)this.obstructionAwareEntity).field_70170_p, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    if (nodeType != PathNodeType.BLOCKED || (collisionBox = state.func_185890_d((IBlockAccess)((EntityLiving)this.obstructionAwareEntity).field_70170_p, pos)) == null || !collisionBox.func_186670_a(pos).func_72326_a(this.obstructionAwareEntity.func_174813_aQ().func_72321_a(Math.signum(diff.field_72450_a) * 0.2, Math.signum(diff.field_72448_b) * 0.2, Math.signum(diff.field_72449_c) * 0.2))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IAdvancedPathFindingEntity)this.obstructionAwareEntity).getMaxStuckCheckTicks()) {
                    ((IAdvancedPathFindingEntity)this.obstructionAwareEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }
}

