/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class CustomPathFinder
extends PathFinder {
    private final PathHeap path = new PathHeap();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;
    private int maxExpansions = 200;
    public static final Heuristic DEFAULT_HEURISTIC = (start, end, isTargetHeuristic) -> start.func_186281_c(end);
    private Heuristic heuristic = DEFAULT_HEURISTIC;

    public CustomPathFinder(NodeProcessor processor) {
        super(processor);
        this.nodeProcessor = processor;
    }

    public NodeProcessor getNodeProcessor() {
        return this.nodeProcessor;
    }

    public CustomPathFinder setMaxExpansions(int expansions) {
        this.maxExpansions = expansions;
        return this;
    }

    public CustomPathFinder setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }

    @Nullable
    public Path func_186333_a(IBlockAccess worldIn, EntityLiving EntityLivingIn, Entity targetEntity, float maxDistance) {
        return this.findPath(worldIn, EntityLivingIn, targetEntity.field_70165_t, targetEntity.func_174813_aQ().field_72338_b, targetEntity.field_70161_v, maxDistance);
    }

    @Nullable
    public Path func_186336_a(IBlockAccess worldIn, EntityLiving EntityLivingIn, BlockPos targetPos, float maxDistance) {
        return this.findPath(worldIn, EntityLivingIn, (float)targetPos.func_177958_n() + 0.5f, (float)targetPos.func_177956_o() + 0.5f, (float)targetPos.func_177952_p() + 0.5f, maxDistance);
    }

    @Nullable
    private Path findPath(IBlockAccess worldIn, EntityLiving EntityLivingIn, double x, double y, double z, float maxDistance) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(worldIn, EntityLivingIn);
        PathPoint startPathPoint = this.nodeProcessor.func_186318_b();
        PathPoint targetPathPoint = this.nodeProcessor.func_186325_a(x, y, z);
        Path path = this.findPath(startPathPoint, targetPathPoint, maxDistance);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(PathPoint startPathPoint, PathPoint targetPathPoint, float maxDistance) {
        startPathPoint.field_75836_e = 0.0f;
        startPathPoint.field_75834_g = startPathPoint.field_75833_f = this.heuristic.compute(startPathPoint, targetPathPoint, true);
        this.path.func_75848_a();
        this.path.func_75849_a(startPathPoint);
        PathPoint finalPathPoint = startPathPoint;
        int expansions = 0;
        while (!this.path.func_75845_e() && ++expansions < this.maxExpansions) {
            PathPoint openPathPoint = this.path.func_75844_c();
            if (openPathPoint.equals((Object)targetPathPoint)) {
                finalPathPoint = targetPathPoint;
                break;
            }
            if (this.heuristic.compute(openPathPoint, targetPathPoint, true) < this.heuristic.compute(finalPathPoint, targetPathPoint, true)) {
                finalPathPoint = openPathPoint;
            }
            openPathPoint.field_75842_i = true;
            int numOptions = this.nodeProcessor.func_186320_a(this.pathOptions, openPathPoint, targetPathPoint, maxDistance);
            for (int i = 0; i < numOptions; ++i) {
                PathPoint successorPathPoint = this.pathOptions[i];
                float costHeuristic = this.heuristic.compute(openPathPoint, successorPathPoint, false);
                successorPathPoint.field_186284_j = openPathPoint.field_186284_j + costHeuristic;
                successorPathPoint.field_186285_k = costHeuristic + successorPathPoint.field_186286_l;
                float totalSuccessorPathCost = openPathPoint.field_75836_e + successorPathPoint.field_186285_k;
                if (!(successorPathPoint.field_186284_j < maxDistance) || successorPathPoint.func_75831_a() && !(totalSuccessorPathCost < successorPathPoint.field_75836_e)) continue;
                successorPathPoint.field_75841_h = openPathPoint;
                successorPathPoint.field_75836_e = totalSuccessorPathCost;
                successorPathPoint.field_75833_f = this.heuristic.compute(successorPathPoint, targetPathPoint, true) + successorPathPoint.field_186286_l;
                if (successorPathPoint.func_75831_a()) {
                    this.path.func_75850_a(successorPathPoint, successorPathPoint.field_75836_e + successorPathPoint.field_75833_f);
                    continue;
                }
                successorPathPoint.field_75834_g = successorPathPoint.field_75836_e + successorPathPoint.field_75833_f;
                this.path.func_75849_a(successorPathPoint);
            }
        }
        if (finalPathPoint == startPathPoint) {
            return null;
        }
        Path path = this.createPath(startPathPoint, finalPathPoint);
        return path;
    }

    private Path createPath(PathPoint start, PathPoint end) {
        int pathLength = 1;
        PathPoint pathpoint = end;
        while (pathpoint.field_75841_h != null) {
            ++pathLength;
            pathpoint = pathpoint.field_75841_h;
        }
        PathPoint[] path = new PathPoint[pathLength];
        PathPoint currentPathPoint = end;
        path[--pathLength] = end;
        while (currentPathPoint.field_75841_h != null) {
            currentPathPoint = currentPathPoint.field_75841_h;
            path[--pathLength] = currentPathPoint;
        }
        return new Path(path);
    }

    public static interface Heuristic {
        public float compute(PathPoint var1, PathPoint var2, boolean var3);
    }
}

