/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.compat.mobends;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.controller.IAnimationController;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.math.SmoothOrientation;
import java.util.ArrayList;
import java.util.Collection;
import tcb.spiderstpo.common.entity.mob.BetterSpiderEntity;
import tcb.spiderstpo.compat.mobends.BetterSpiderCrawlAnimationBit;
import tcb.spiderstpo.compat.mobends.BetterSpiderData;
import tcb.spiderstpo.compat.mobends.BetterSpiderDeathAnimationBit;
import tcb.spiderstpo.compat.mobends.BetterSpiderIdleAnimationBit;
import tcb.spiderstpo.compat.mobends.BetterSpiderJumpAnimationBit;
import tcb.spiderstpo.compat.mobends.BetterSpiderMoveAnimationBit;

public class BetterSpiderController
implements IAnimationController<BetterSpiderData> {
    protected HardAnimationLayer<BetterSpiderData> layerBase = new HardAnimationLayer();
    protected AnimationBit<BetterSpiderData> bitIdle = new BetterSpiderIdleAnimationBit();
    protected AnimationBit<BetterSpiderData> bitMove = new BetterSpiderMoveAnimationBit();
    protected AnimationBit<BetterSpiderData> bitJump = new BetterSpiderJumpAnimationBit();
    protected AnimationBit<BetterSpiderData> bitDeath = new BetterSpiderDeathAnimationBit();
    protected AnimationBit<BetterSpiderData> bitClimb = new BetterSpiderCrawlAnimationBit();
    protected boolean resetAfterJumped = false;

    public Collection<String> perform(BetterSpiderData spiderData) {
        BetterSpiderEntity spider = (BetterSpiderEntity)spiderData.getEntity();
        if (spider.func_110143_aJ() <= 0.0f) {
            this.layerBase.playOrContinueBit(this.bitDeath, (EntityData)spiderData);
        } else if (spider.getOrientation((float)1.0f).normal.field_72448_b < 0.5) {
            this.layerBase.playOrContinueBit(this.bitClimb, (EntityData)spiderData);
        } else if (!spiderData.isOnGround() || spiderData.getTicksAfterTouchdown() < 1.0f) {
            this.layerBase.playOrContinueBit(this.bitJump, (EntityData)spiderData);
            if (this.resetAfterJumped) {
                this.resetAfterJumped = false;
            }
        } else {
            if (!this.resetAfterJumped) {
                for (BetterSpiderData.Limb limb : spiderData.limbs) {
                    limb.resetPosition();
                }
                this.resetAfterJumped = true;
            }
            if (spiderData.isStillHorizontally()) {
                this.layerBase.playOrContinueBit(this.bitIdle, (EntityData)spiderData);
            } else {
                this.layerBase.playOrContinueBit(this.bitMove, (EntityData)spiderData);
            }
        }
        ArrayList<String> actions = new ArrayList<String>();
        this.layerBase.perform((EntityData)spiderData, actions);
        return actions;
    }

    public static void putLimbOnGround(SmoothOrientation upperLimb, SmoothOrientation lowerLimb, boolean odd, double stretchDistance, double groundLevel) {
        BetterSpiderController.putLimbOnGround(upperLimb, lowerLimb, odd, stretchDistance, groundLevel, 1.0f);
        upperLimb.finish();
        lowerLimb.finish();
    }

    public static void putLimbOnGround(SmoothOrientation upperLimb, SmoothOrientation lowerLimb, boolean odd, double stretchDistance, double groundLevel, float smoothness) {
        double c;
        float limbSegmentLength = 12.0f;
        float maxStretch = 24.0f;
        double d = c = groundLevel == 0.0 ? stretchDistance : Math.sqrt(stretchDistance * stretchDistance + groundLevel * groundLevel);
        if (c > 24.0) {
            c = 24.0;
        }
        double alpha = c > 24.0 ? 0.0 : Math.acos(c / 2.0 / 12.0);
        double beta = Math.atan2(stretchDistance, -groundLevel);
        double lowerAngle = Math.max(-2.3, -2.0 * alpha);
        double upperAngle = Math.min(1.0, alpha + beta - 1.5707963267948966);
        upperLimb.setSmoothness(smoothness).localRotateZ((float)(upperAngle / Math.PI * 180.0) * (float)(odd ? -1 : 1));
        lowerLimb.setSmoothness(smoothness).orientZ((float)(lowerAngle / Math.PI * 180.0) * (float)(odd ? -1 : 1));
    }
}

