/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.compat.mobends;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.client.event.DataUpdateHandler;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.util.GUtil;
import net.minecraft.util.math.MathHelper;
import tcb.spiderstpo.common.entity.mob.BetterSpiderEntity;
import tcb.spiderstpo.compat.mobends.BetterSpiderData;

public class BetterSpiderIdleAnimationBit
extends AnimationBit<BetterSpiderData> {
    protected static final float KNEEL_DURATION = 10.0f;

    public String[] getActions(BetterSpiderData entityData) {
        return new String[]{"idle"};
    }

    public void onPlay(BetterSpiderData data) {
        super.onPlay((EntityData)data);
    }

    public void perform(BetterSpiderData data) {
        float ticks = DataUpdateHandler.getTicks();
        float pt = DataUpdateHandler.partialTicks;
        BetterSpiderEntity spider = (BetterSpiderEntity)data.getEntity();
        float headYaw = ((Float)data.headYaw.get()).floatValue();
        float headPitch = ((Float)data.headPitch.get()).floatValue();
        double groundLevel = Math.sin(ticks * 0.1f) * 0.5;
        float touchdown = Math.min(data.getTicksAfterTouchdown() / 10.0f, 1.0f);
        if (touchdown < 1.0f) {
            float preBounce = 0.0f;
            float touchdownInv = 1.0f - touchdown;
            groundLevel += Math.sin((double)(touchdown * 1.0f - 0.0f) * Math.PI * 2.0) * 4.0 * (double)touchdownInv;
        }
        data.spiderHead.rotation.orientInstantX(headPitch);
        data.spiderHead.rotation.rotateY(headYaw).finish();
        double bodyX = Math.sin(ticks * 0.2f) * 0.4;
        double bodyZ = Math.cos(ticks * 0.2f) * 0.4;
        for (BetterSpiderData.Limb limb : data.limbs) {
            BetterSpiderData.IKResult ikResult = limb.solveIK(bodyX, bodyZ, pt);
            double deviation = GUtil.getRadianDifference((double)limb.getNeutralYaw(), (double)(ikResult.xzAngle + 1.5707963267948966));
            if (deviation > 0.9 || ikResult.xzDistance * 0.0625 > 1.2) {
                limb.adjustToNeutralPosition();
            }
            limb.applyIK(ikResult, groundLevel, 4.0, pt);
        }
        if (spider.field_70173_aa % 100 < 10) {
            data.limbs[6].adjustToLocalPosition(0.0, 1.5, 0.2f);
            data.limbs[7].adjustToLocalPosition(0.0, 1.5, 0.2f);
        }
        float climbingRotation = 0.0f;
        float renderRotationY = MathHelper.func_76142_g((float)(spider.field_70177_z - ((Float)data.headYaw.get()).floatValue() - climbingRotation));
        data.localOffset.slideToZero();
        data.globalOffset.set((float)bodyX, (float)(-groundLevel), (float)(-bodyZ));
        data.centerRotation.orientZero();
        data.renderRotation.orientZero();
    }
}

