/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toughasnails.command.TANCommand;
import toughasnails.core.CommonProxy;
import toughasnails.handler.BlockHarvestEventHandler;
import toughasnails.handler.LootTableEventHandler;
import toughasnails.init.ModBlocks;
import toughasnails.init.ModCompat;
import toughasnails.init.ModConfig;
import toughasnails.init.ModCrafting;
import toughasnails.init.ModEntities;
import toughasnails.init.ModHandlers;
import toughasnails.init.ModItems;
import toughasnails.init.ModPotions;
import toughasnails.init.ModStats;
import toughasnails.init.ModVanillaCompat;

@Mod(modid="toughasnails", version="3.1.0.141", name="Tough As Nails", dependencies="required-after:forge@[14.23.5.2768,)", guiFactory="toughasnails.client.gui.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class ToughAsNails {
    public static final String MOD_NAME = "Tough As Nails";
    public static final String MOD_ID = "toughasnails";
    public static final String MOD_VERSION = "3.1.0.141";
    public static final String GUI_FACTORY = "toughasnails.client.gui.GuiFactory";
    @Mod.Instance(value="toughasnails")
    public static ToughAsNails instance;
    @SidedProxy(clientSide="toughasnails.core.ClientProxy", serverSide="toughasnails.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static File configDirectory;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = new File(event.getModConfigurationDirectory(), MOD_ID);
        ModConfig.preInit(configDirectory);
        ModBlocks.init();
        ModEntities.init();
        ModItems.init();
        ModStats.init();
        ModPotions.init();
        ModVanillaCompat.init();
        ModHandlers.init();
        ModCrafting.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new LootTableEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlockHarvestEventHandler());
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCrafting.init();
        ModConfig.init(configDirectory);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModCompat.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new TANCommand());
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

