/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.config.json.ArmorTemperatureData;
import toughasnails.init.ModConfig;
import toughasnails.init.ModEnchantments;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.config.NBTUtilExt;

public class ArmorModifier
extends TemperatureModifier {
    public ArmorModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyPlayerModifiers(EntityPlayer player, Temperature initialTemperature, IModifierMonitor monitor) {
        int newTemperatureLevel = initialTemperature.getRawValue();
        InventoryPlayer inventory = player.field_71071_by;
        block0: for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)inventory.field_70460_b.get(i);
            String name = armor.func_77973_b().getRegistryName().toString();
            for (int j = 0; j < ModConfig.armorTemperatureData.size(); ++j) {
                NBTTagCompound compare;
                ArmorTemperatureData atd = ModConfig.armorTemperatureData.get(j);
                int index = atd.names.indexOf(name);
                if (index < 0) continue;
                NBTTagCompound nBTTagCompound = compare = atd.nbts == null ? null : atd.getNBTTagCompounds().get(index);
                if (!NBTUtilExt.areNBTsEqualOrNull(armor.func_77978_p(), compare)) continue;
                newTemperatureLevel += atd.modifier;
                continue block0;
            }
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)armor);
            if (enchantments.containsKey(ModEnchantments.COOLING)) {
                --newTemperatureLevel;
                continue;
            }
            if (!enchantments.containsKey(ModEnchantments.WARMING)) continue;
            ++newTemperatureLevel;
        }
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Armor", initialTemperature, new Temperature(newTemperatureLevel)));
        return new Temperature(newTemperatureLevel);
    }

    @Override
    public boolean isPlayerSpecific() {
        return true;
    }
}

