/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ThermalFluidHandlerItemStack
extends FluidHandlerItemStack {
    public final int minFluidTemperature;
    public final int maxFluidTemperature;

    public ThermalFluidHandlerItemStack(@Nonnull ItemStack container, int capacity, int minFluidTemperature, int maxFluidTemperature) {
        super(container, capacity);
        this.minFluidTemperature = minFluidTemperature;
        this.maxFluidTemperature = maxFluidTemperature;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        int liquidTemperature = fluid.getFluid().getTemperature();
        return liquidTemperature >= this.minFluidTemperature && liquidTemperature <= this.maxFluidTemperature;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = super.drain(resource, doDrain);
        this.removeTagWhenEmpty(doDrain);
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        this.removeTagWhenEmpty(doDrain);
        return drained;
    }

    private void removeTagWhenEmpty(Boolean doDrain) {
        if (doDrain.booleanValue() && this.getFluid() == null) {
            this.container.func_77982_d(null);
        }
    }
}

