/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.Lists;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.IUIHolder;
import gregtech.api.render.SimpleSidedCubeRenderer;
import gregtech.api.render.Textures;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CoverBehavior
implements IUIHolder {
    private CoverDefinition coverDefinition;
    public final ICoverable coverHolder;
    public final EnumFacing attachedSide;
    private int redstoneSignalOutput;

    public CoverBehavior(ICoverable coverHolder, EnumFacing attachedSide) {
        this.coverHolder = coverHolder;
        this.attachedSide = attachedSide;
    }

    final void setCoverDefinition(CoverDefinition coverDefinition) {
        this.coverDefinition = coverDefinition;
    }

    public final CoverDefinition getCoverDefinition() {
        return this.coverDefinition;
    }

    public final void setRedstoneSignalOutput(int redstoneSignalOutput) {
        this.redstoneSignalOutput = redstoneSignalOutput;
        this.coverHolder.notifyBlockUpdate();
        this.coverHolder.markDirty();
    }

    public final int getRedstoneSignalOutput() {
        return this.redstoneSignalOutput;
    }

    public final int getRedstoneSignalInput() {
        return this.coverHolder.getInputRedstoneSignal(this.attachedSide, true);
    }

    public void onRedstoneInputSignalChange(int newSignalStrength) {
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (this.redstoneSignalOutput > 0) {
            tagCompound.func_74768_a("RedstoneSignal", this.redstoneSignalOutput);
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.redstoneSignalOutput = tagCompound.func_74762_e("RedstoneSignal");
    }

    public void writeInitialSyncData(PacketBuffer packetBuffer) {
    }

    public void readInitialSyncData(PacketBuffer packetBuffer) {
    }

    public void readUpdateData(int id, PacketBuffer packetBuffer) {
    }

    public final void writeUpdateData(int id, Consumer<PacketBuffer> writer) {
        this.coverHolder.writeCoverData(this, id, writer);
    }

    public abstract boolean canAttach();

    public void onAttached(ItemStack itemStack) {
    }

    public boolean shouldCoverInteractWithOutputside() {
        return false;
    }

    public ItemStack getPickItem() {
        return this.coverDefinition.getDropItemStack();
    }

    public List<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getPickItem()});
    }

    public void onRemoved() {
    }

    public boolean shouldRenderConnected() {
        return true;
    }

    public boolean canPipePassThrough() {
        return false;
    }

    public boolean canRenderBackside() {
        return true;
    }

    public boolean onLeftClick(EntityPlayer entityPlayer, CuboidRayTraceResult hitResult) {
        return false;
    }

    public EnumActionResult onRightClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        return EnumActionResult.PASS;
    }

    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        return EnumActionResult.PASS;
    }

    public <T> T getCapability(Capability<T> capability, T defaultValue) {
        return defaultValue;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderCover(CCRenderState var1, Matrix4 var2, IVertexOperation[] var3, Cuboid6 var4, BlockRenderLayer var5);

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(BlockRenderLayer renderLayer) {
        return renderLayer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCoverPlate(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        TextureAtlasSprite casingSide = this.getPlateSprite();
        for (EnumFacing coverPlateSide : EnumFacing.field_82609_l) {
            boolean isAttachedSide;
            boolean bl = isAttachedSide = this.attachedSide.func_176740_k() == coverPlateSide.func_176740_k();
            if (isAttachedSide) {
                Textures.renderFace(renderState, translation, pipeline, coverPlateSide, plateBox, casingSide);
                continue;
            }
            if (this.coverHolder.getCoverAtSide(coverPlateSide) != null) continue;
            Textures.renderFace(renderState, translation, pipeline, coverPlateSide, plateBox, casingSide);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[1].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    @Override
    public final boolean isValid() {
        return this.coverHolder.isValid() && this.coverHolder.getCoverAtSide(this.attachedSide) == this;
    }

    @Override
    public boolean isRemote() {
        return this.coverHolder.getWorld().field_72995_K;
    }

    @Override
    public final void markAsDirty() {
        this.coverHolder.markDirty();
    }
}

