/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.impl;

import com.google.common.collect.ImmutableSet;
import gregtech.api.gui.Widget;
import gregtech.api.gui.igredient.IGhostIngredientTarget;
import gregtech.api.gui.igredient.IIngredientSlot;
import gregtech.api.gui.igredient.IRecipeTransferHandlerWidget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.impl.ModularUIGui;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ModularUIGuiHandler
implements IAdvancedGuiHandler<ModularUIGui>,
IGhostIngredientHandler<ModularUIGui>,
IRecipeTransferHandler<ModularUIContainer> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public ModularUIGuiHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ModularUIGui> getGuiContainerClass() {
        return ModularUIGui.class;
    }

    public Class<ModularUIContainer> getContainerClass() {
        return ModularUIContainer.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ModularUIContainer container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        Optional<IRecipeTransferHandlerWidget> transferHandler = container.getModularUI().getFlatVisibleWidgetCollection().stream().filter(it -> it instanceof IRecipeTransferHandlerWidget).map(it -> (IRecipeTransferHandlerWidget)((Object)it)).findFirst();
        if (!transferHandler.isPresent()) {
            return this.transferHelper.createInternalError();
        }
        HashMap<Integer, IGuiIngredient<ItemStack>> group = new HashMap<Integer, IGuiIngredient<ItemStack>>(recipeLayout.getItemStacks().getGuiIngredients());
        group.values().removeIf(it -> it.getAllIngredients().isEmpty());
        String errorTooltip = transferHandler.get().transferRecipe(container, group, player, maxTransfer, doTransfer);
        if (errorTooltip == null) {
            return null;
        }
        return this.transferHelper.createUserErrorWithTooltip(errorTooltip);
    }

    @Nullable
    public Object getIngredientUnderMouse(ModularUIGui gui, int mouseX, int mouseY) {
        ImmutableSet widgets = gui.getModularUI().guiWidgets.values();
        for (Widget widget : widgets) {
            Object result;
            if (!(widget instanceof IIngredientSlot) || (result = ((IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(ModularUIGui gui, I ingredient, boolean doStart) {
        ImmutableSet widgets = gui.getModularUI().guiWidgets.values();
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (Widget widget : widgets) {
            if (!(widget instanceof IGhostIngredientTarget)) continue;
            IGhostIngredientTarget ghostTarget = (IGhostIngredientTarget)((Object)widget);
            List<IGhostIngredientHandler.Target<?>> widgetTargets = ghostTarget.getPhantomTargets(ingredient);
            targets.addAll(widgetTargets);
        }
        return targets;
    }

    @Nullable
    public List<Rectangle> getGuiExtraAreas(ModularUIGui guiContainer) {
        return Collections.emptyList();
    }

    public void onComplete() {
    }
}

