/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import gregtech.api.util.Position;
import gregtech.api.util.PositionedRect;
import gregtech.api.util.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureArea {
    public final ResourceLocation imageLocation;
    public final double offsetX;
    public final double offsetY;
    public final double imageWidth;
    public final double imageHeight;

    public TextureArea(ResourceLocation imageLocation, double offsetX, double offsetY, double width, double height) {
        this.imageLocation = imageLocation;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public static TextureArea fullImage(String imageLocation) {
        return new TextureArea(new ResourceLocation("gregtech", imageLocation), 0.0, 0.0, 1.0, 1.0);
    }

    public static TextureArea areaOfImage(String imageLocation, int imageSizeX, int imageSizeY, int u, int v, int width, int height) {
        return new TextureArea(new ResourceLocation(imageLocation), (double)u / ((double)imageSizeX * 1.0), (double)v / ((double)imageSizeY * 1.0), (double)(u + width) / ((double)imageSizeX * 1.0), (double)(v + height) / ((double)imageSizeY * 1.0));
    }

    public TextureArea getSubArea(double offsetX, double offsetY, double width, double height) {
        return new TextureArea(this.imageLocation, this.offsetX + this.imageWidth * offsetX, this.offsetY + this.imageHeight * offsetY, this.imageWidth * width, this.imageHeight * height);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawRotated(int x, int y, Size areaSize, PositionedRect positionedRect, int orientation) {
        Transformation transformation = TextureArea.createOrientation(areaSize, orientation);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        transformation.glApply();
        this.draw(positionedRect.position.x, positionedRect.position.y, positionedRect.size.width, positionedRect.size.height);
        GlStateManager.func_179121_F();
    }

    public static Transformation createOrientation(Size areaSize, int orientation) {
        Transformation transformation = new Rotation(Math.toRadians((double)orientation * 90.0), 0.0, 0.0, 1.0).at(new Vector3((double)areaSize.width / 2.0, (double)areaSize.height / 2.0, 0.0));
        Size orientedSize = TextureArea.transformSize(transformation, areaSize);
        double offsetX = (double)(areaSize.width - orientedSize.width) / 2.0;
        double offsetY = (double)(areaSize.height - orientedSize.height) / 2.0;
        return transformation.with((Transformation)new Translation(-offsetX, -offsetY, 0.0));
    }

    public static Size transformSize(Transformation transformation, Size position) {
        Vector3 sizeVector = new Vector3((double)position.width, (double)position.height, 0.0);
        Vector3 zeroVector = new Vector3(0.0, 0.0, 0.0);
        transformation.apply((Object)zeroVector);
        transformation.apply((Object)sizeVector);
        sizeVector.subtract(zeroVector);
        return new Size((int)Math.abs(sizeVector.x), (int)Math.abs(sizeVector.y));
    }

    public static PositionedRect transformRect(Transformation transformation, PositionedRect positionedRect) {
        Position pos1 = TextureArea.transformPos(transformation, positionedRect.position);
        Position pos2 = TextureArea.transformPos(transformation, positionedRect.position.add(positionedRect.size));
        return new PositionedRect(pos1, pos2);
    }

    public static Position transformPos(Transformation transformation, Position position) {
        Vector3 vector = new Vector3((double)position.x, (double)position.y, 0.0);
        transformation.apply((Object)vector);
        return new Position((int)vector.x, (int)vector.y);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(double x, double y, int width, int height) {
        this.drawSubArea(x, y, width, height, 0.0, 0.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSubArea(double x, double y, int width, int height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
        double imageU = this.offsetX + this.imageWidth * drawnU;
        double imageV = this.offsetY + this.imageHeight * drawnV;
        double imageWidth = this.imageWidth * drawnWidth;
        double imageHeight = this.imageHeight * drawnHeight;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.imageLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + (double)height, 0.0).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
        bufferbuilder.func_181662_b(x + (double)width, y, 0.0).func_187315_a(imageU + imageWidth, imageV).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(imageU, imageV).func_181675_d();
        tessellator.func_78381_a();
    }
}

