/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.Lists;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.igredient.IGhostIngredientTarget;
import gregtech.api.gui.igredient.IIngredientSlot;
import gregtech.api.gui.resources.RenderUtil;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PhantomFluidWidget
extends Widget
implements IIngredientSlot,
IGhostIngredientTarget {
    protected TextureArea backgroundTexture = GuiTextures.FLUID_SLOT;
    private Supplier<FluidStack> fluidStackSupplier;
    private Consumer<FluidStack> fluidStackUpdater;
    protected FluidStack lastFluidStack;

    public PhantomFluidWidget(int xPosition, int yPosition, int width, int height, Supplier<FluidStack> fluidStackSupplier, Consumer<FluidStack> fluidStackUpdater) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        this.fluidStackSupplier = fluidStackSupplier;
        this.fluidStackUpdater = fluidStackUpdater;
    }

    private FluidStack drainFrom(Object ingredient) {
        ItemStack itemStack;
        IFluidHandlerItem fluidHandler;
        if (ingredient instanceof ItemStack && (fluidHandler = (IFluidHandlerItem)(itemStack = (ItemStack)ingredient).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof FluidStack) && this.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(Object ingredient) {
                FluidStack ingredientStack = ingredient instanceof FluidStack ? (FluidStack)ingredient : PhantomFluidWidget.this.drainFrom(ingredient);
                if (ingredientStack != null) {
                    NBTTagCompound tagCompound = ingredientStack.writeToNBT(new NBTTagCompound());
                    PhantomFluidWidget.this.writeClientAction(2, buffer -> buffer.func_150786_a(tagCompound));
                }
            }
        }});
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidStack;
        }
        return null;
    }

    public PhantomFluidWidget setBackgroundTexture(TextureArea backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack currentStack = this.fluidStackSupplier.get();
        if (currentStack == null && this.lastFluidStack != null) {
            this.lastFluidStack = null;
            this.writeUpdateInfo(1, buffer -> buffer.writeBoolean(false));
        } else if (currentStack != null && !currentStack.isFluidStackIdentical(this.lastFluidStack)) {
            this.lastFluidStack = currentStack;
            this.writeUpdateInfo(1, buffer -> {
                buffer.writeBoolean(true);
                buffer.func_150786_a(currentStack.writeToNBT(new NBTTagCompound()));
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            if (buffer.readBoolean()) {
                try {
                    NBTTagCompound tagCompound = buffer.func_150793_b();
                    this.lastFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.lastFluidStack = null;
            }
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            ItemStack itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o().func_77946_l();
            if (!itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler != null) {
                    FluidStack resultFluid = fluidHandler.drain(Integer.MAX_VALUE, false);
                    this.fluidStackUpdater.accept(resultFluid);
                }
            } else {
                this.fluidStackUpdater.accept(null);
            }
        } else if (id == 2) {
            FluidStack fluidStack;
            try {
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fluidStackUpdater.accept(fluidStack);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(1, buffer -> {});
            return true;
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            this.backgroundTexture.draw(pos.x, pos.y, size.width, size.height);
        }
        if (this.lastFluidStack != null) {
            GlStateManager.func_179084_k();
            RenderUtil.drawFluidForGui(this.lastFluidStack, this.lastFluidStack.amount, pos.x + 1, pos.y + 1, size.width - 1, size.height - 1);
            GlStateManager.func_179147_l();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.lastFluidStack != null) {
            String fluidName = this.lastFluidStack.getLocalizedName();
            this.drawHoveringText(ItemStack.field_190927_a, Lists.newArrayList((Object[])new String[]{fluidName}), -1, mouseX, mouseY);
        }
    }
}

