/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.IScissored;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotWidget
extends Widget
implements INativeWidget {
    protected Slot slotReference;
    protected boolean isEnabled = true;
    protected boolean canTakeItems;
    protected boolean canPutItems;
    protected INativeWidget.SlotLocationInfo locationInfo = new INativeWidget.SlotLocationInfo(false, false);
    protected TextureArea[] backgroundTexture;
    protected Runnable changeListener;
    protected Rectangle scissor;

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(inventory, slotIndex);
    }

    public SlotWidget(IItemHandler itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(itemHandler, slotIndex);
    }

    protected Slot createSlot(IInventory inventory, int index) {
        return new WidgetSlot(inventory, index, 0, 0);
    }

    protected Slot createSlot(IItemHandler itemHandler, int index) {
        return new WidgetSlotItemHandler(itemHandler, index, 0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        if (this.isEnabled() && this.backgroundTexture != null) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            for (TextureArea backgroundTexture : this.backgroundTexture) {
                backgroundTexture.draw(pos.x, pos.y, size.width, size.height);
            }
        }
    }

    @Override
    protected void onPositionUpdate() {
        if (this.slotReference != null && this.sizes != null) {
            Position position = this.getPosition();
            this.slotReference.field_75223_e = position.x + 1 - this.sizes.getGuiLeft();
            this.slotReference.field_75221_f = position.y + 1 - this.sizes.getGuiTop();
        }
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public void applyScissor(int parentX, int parentY, int parentWidth, int parentHeight) {
        this.scissor = new Rectangle(parentX, parentY, parentWidth, parentHeight);
    }

    @Override
    public void detectAndSendChanges() {
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(TextureArea ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public SlotWidget setLocationInfo(boolean isPlayerInventory, boolean isHotbarSlot) {
        this.locationInfo = new INativeWidget.SlotLocationInfo(isPlayerInventory, isHotbarSlot);
        return this;
    }

    @Override
    public INativeWidget.SlotLocationInfo getSlotLocationInfo() {
        return this.locationInfo;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled() && this.canPutItems;
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.isEnabled() && this.canTakeItems;
    }

    public boolean isEnabled() {
        if (!this.isEnabled) {
            return false;
        }
        if (this.scissor == null) {
            return true;
        }
        return this.scissor.intersects(this.toRectangleBox());
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled();
    }

    public void onSlotChanged() {
        this.gui.holder.markAsDirty();
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return INativeWidget.VANILLA_LOGIC;
    }

    @Override
    public final Slot getHandle() {
        return this.slotReference;
    }

    @Deprecated
    protected class WidgetSlotDelegate
    extends SlotItemHandler
    implements IScissored {
        public WidgetSlotDelegate(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public final ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }

        @Override
        public Rectangle getScissor() {
            return SlotWidget.this.scissor;
        }
    }

    protected class WidgetSlotItemHandler
    extends SlotItemHandler
    implements IScissored {
        public WidgetSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public final ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }

        @Override
        public Rectangle getScissor() {
            return SlotWidget.this.scissor;
        }
    }

    protected class WidgetSlot
    extends Slot
    implements IScissored {
        public WidgetSlot(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        public final ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }

        @Override
        public Rectangle getScissor() {
            return SlotWidget.this.scissor;
        }
    }
}

