/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.mojang.realmsclient.gui.ChatFormatting;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.igredient.IIngredientSlot;
import gregtech.api.gui.resources.RenderUtil;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.FluidTooltipUtil;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TankWidget
extends Widget
implements IIngredientSlot {
    public final IFluidTank fluidTank;
    public int fluidRenderOffset = 1;
    private boolean hideTooltip;
    private boolean alwaysShowFull;
    private boolean allowClickFilling;
    private boolean allowClickEmptying;
    private TextureArea[] backgroundTexture;
    private TextureArea overlayTexture;
    private FluidStack lastFluidInTank;
    private int lastTankCapacity;

    public TankWidget(IFluidTank fluidTank, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidTank;
    }

    public TankWidget setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
        return this;
    }

    public TankWidget setAlwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public TankWidget setBackgroundTexture(TextureArea ... backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public TankWidget setOverlayTexture(TextureArea overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public TankWidget setFluidRenderOffset(int fluidRenderOffset) {
        this.fluidRenderOffset = fluidRenderOffset;
        return this;
    }

    public TankWidget setContainerClicking(boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        if (!(this.fluidTank instanceof IFluidHandler)) {
            throw new IllegalStateException("Container IO is only supported for fluid tanks that implement IFluidHandler");
        }
        this.allowClickFilling = allowClickContainerFilling;
        this.allowClickEmptying = allowClickContainerEmptying;
        return this;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidInTank;
        }
        return null;
    }

    public String getFormattedFluidAmount() {
        return String.format("%,d", this.lastFluidInTank == null ? 0 : this.lastFluidInTank.amount);
    }

    public String getFluidLocalizedName() {
        return this.lastFluidInTank == null ? "" : this.lastFluidInTank.getLocalizedName();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            for (TextureArea textureArea : this.backgroundTexture) {
                textureArea.draw(pos.x, pos.y, size.width, size.height);
            }
        }
        if (this.lastFluidInTank != null && this.lastFluidInTank.amount > 0 && !this.gui.isJEIHandled) {
            GlStateManager.func_179084_k();
            RenderUtil.drawFluidForGui(this.lastFluidInTank, this.alwaysShowFull ? this.lastFluidInTank.amount : this.lastTankCapacity, pos.x + this.fluidRenderOffset, pos.y + this.fluidRenderOffset, size.width - this.fluidRenderOffset, size.height - this.fluidRenderOffset);
            int bucketsAmount = this.lastFluidInTank.amount / 1000;
            if (this.alwaysShowFull && !this.hideTooltip && bucketsAmount > 0) {
                String s = String.valueOf(bucketsAmount);
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(s, (float)(pos.x + 1 + size.width - 2 - fontRenderer.func_78256_a(s)), (float)(pos.y + size.height / 3 + 3), 0xFFFFFF);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.draw(pos.x, pos.y, size.width, size.height);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (!this.hideTooltip && !this.gui.isJEIHandled && this.isMouseOverElement(mouseX, mouseY)) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (this.lastFluidInTank != null) {
                Fluid fluid = this.lastFluidInTank.getFluid();
                tooltips.add(fluid.getLocalizedName(this.lastFluidInTank));
                String formula = FluidTooltipUtil.getFluidTooltip(this.lastFluidInTank);
                if (formula != null && !formula.isEmpty()) {
                    tooltips.add(ChatFormatting.GRAY.toString() + formula);
                }
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.amount", (Object[])new Object[]{this.lastFluidInTank.amount, this.lastTankCapacity}));
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.temperature", (Object[])new Object[]{fluid.getTemperature(this.lastFluidInTank)}));
                tooltips.add(I18n.func_135052_a((String)(fluid.isGaseous(this.lastFluidInTank) ? "gregtech.fluid.state_gas" : "gregtech.fluid.state_liquid"), (Object[])new Object[0]));
            } else {
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.empty", (Object[])new Object[0]));
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}));
            }
            if (this.allowClickFilling) {
                tooltips.add("");
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.click_to_fill", (Object[])new Object[0]));
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.click_to_fill.shift", (Object[])new Object[0]));
            }
            if (this.allowClickEmptying) {
                tooltips.add("");
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.click_to_empty", (Object[])new Object[0]));
                tooltips.add(I18n.func_135052_a((String)"gregtech.fluid.click_to_empty.shift", (Object[])new Object[0]));
            }
            this.drawHoveringText(ItemStack.field_190927_a, tooltips, 300, mouseX, mouseY);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
            this.lastTankCapacity = this.fluidTank.getCapacity();
            this.writeUpdateInfo(0, buffer -> buffer.func_150787_b(this.lastTankCapacity));
        }
        if (fluidStack == null && this.lastFluidInTank != null) {
            this.lastFluidInTank = null;
            this.writeUpdateInfo(1, buffer -> {});
        } else if (fluidStack != null) {
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
                this.writeUpdateInfo(2, buffer -> buffer.func_150786_a(fluidStackTag));
            } else if (fluidStack.amount != this.lastFluidInTank.amount) {
                this.lastFluidInTank.amount = fluidStack.amount;
                this.writeUpdateInfo(3, buffer -> buffer.func_150787_b(this.lastFluidInTank.amount));
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.func_150792_a();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            NBTTagCompound fluidStackTag;
            try {
                fluidStackTag = buffer.func_150793_b();
            }
            catch (IOException ignored) {
                return;
            }
            this.lastFluidInTank = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackTag);
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.amount = buffer.func_150792_a();
        }
        if (id == 4) {
            ItemStack currentStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            int newStackSize = buffer.func_150792_a();
            currentStack.func_190920_e(newStackSize);
            this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.func_150787_b(clickResult));
        }
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        if (!currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.func_190916_E() : 1;
        if (this.allowClickFilling && this.fluidTank.getFluidAmount() > 0) {
            ItemStack remainingStack;
            FluidActionResult result;
            boolean performedFill = false;
            FluidStack initialFluid = this.fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess() && ((remainingStack = result.getResult()).func_190926_b() || player.field_71071_by.func_70441_a(remainingStack)); ++i) {
                FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)true);
                currentStack.func_190918_g(1);
                performedFill = true;
            }
            if (performedFill) {
                SoundEvent soundevent = initialFluid.getFluid().getFillSound(initialFluid);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
                return currentStack.func_190916_E();
            }
        }
        if (this.allowClickEmptying) {
            ItemStack remainingStack;
            FluidActionResult result;
            boolean performedEmptying = false;
            for (int i = 0; i < maxAttempts && (result = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess() && ((remainingStack = result.getResult()).func_190926_b() || player.field_71071_by.func_70441_a(remainingStack)); ++i) {
                FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)true);
                currentStack.func_190918_g(1);
                performedEmptying = true;
            }
            FluidStack filledFluid = this.fluidTank.getFluid();
            if (performedEmptying) {
                SoundEvent soundevent = filledFluid.getFluid().getEmptySound(filledFluid);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
                return currentStack.func_190916_E();
            }
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ItemStack currentStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            if (button == 0 && (this.allowClickEmptying || this.allowClickFilling) && currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                boolean isShiftKeyDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                this.writeClientAction(1, writer -> writer.writeBoolean(isShiftKeyDown));
                this.playButtonClickSound();
                return true;
            }
        }
        return false;
    }
}

