/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.armor;

import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.armor.ElementOrientation;
import gregtech.api.gui.widgets.armor.GridElementWidget;
import gregtech.api.util.Size;
import java.util.function.BiFunction;

public class GridElementDef {
    private final int sizeHorizontal;
    private final int sizeVertical;
    private final BiFunction<Size, Integer, GridElementWidget> supplier;

    public GridElementDef(int sizeHorizontal, int sizeVertical, BiFunction<Size, Integer, GridElementWidget> supplier) {
        this.sizeHorizontal = sizeHorizontal;
        this.sizeVertical = sizeVertical;
        this.supplier = supplier;
    }

    public Size getSizeWithOrientation(ElementOrientation orientation) {
        Size initialSize = new Size(this.sizeHorizontal, this.sizeVertical);
        return TextureArea.transformSize(TextureArea.createOrientation(initialSize, orientation.rotationValue), initialSize);
    }

    public GridElementWidget createWidget(ElementOrientation orientation, int slotSize) {
        GridElementWidget elementWidget = this.supplier.apply(new Size(this.sizeHorizontal * slotSize, this.sizeVertical * slotSize), slotSize);
        elementWidget.setOrientation(orientation);
        return elementWidget;
    }
}

