/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.tab;

import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.tab.ITabInfo;
import gregtech.api.gui.widgets.tab.TabListRenderer;
import gregtech.api.util.Position;
import java.util.List;

public class HorizontalTabListRenderer
extends TabListRenderer {
    private final HorizontalStartCorner startCorner;
    private final VerticalLocation verticalLocation;

    public HorizontalTabListRenderer(HorizontalStartCorner startCorner, VerticalLocation verticalLocation) {
        this.startCorner = startCorner;
        this.verticalLocation = verticalLocation;
    }

    @Override
    public void renderTabs(Position offset, List<ITabInfo> tabInfos, int guiWidth, int guiHeight, int selectedTabIndex) {
        boolean startLeft = this.startCorner == HorizontalStartCorner.LEFT;
        boolean isTopLine = this.verticalLocation == VerticalLocation.TOP;
        int tabYPosition = isTopLine ? -28 : guiHeight - 4;
        int currentXOffset = 0;
        for (int tabIndex = 0; tabIndex < tabInfos.size(); ++tabIndex) {
            boolean isTabSelected = tabIndex == selectedTabIndex;
            boolean isTabFirst = tabIndex == 0;
            TextureArea tabTexture = HorizontalTabListRenderer.getTabTexture(isTabSelected, isTabFirst, isTopLine, startLeft);
            int finalPosX = startLeft ? currentXOffset : guiWidth - 28 - currentXOffset;
            tabInfos.get(tabIndex).renderTab(tabTexture, offset.x + finalPosX, offset.y + tabYPosition, 28, 32, isTabSelected);
            currentXOffset += 28;
        }
    }

    private static TextureArea getTabTexture(boolean isTabSelected, boolean isTabFirst, boolean isTopLine, boolean startLeft) {
        if (isTopLine) {
            return TopTextures.getTabTexture(isTabFirst, startLeft, isTabSelected);
        }
        return BottomTextures.getTabTexture(isTabFirst, startLeft, isTabSelected);
    }

    @Override
    public int[] getTabPos(int tabIndex, int guiWidth, int guiHeight) {
        boolean startLeft = this.startCorner == HorizontalStartCorner.LEFT;
        boolean isTopLine = this.verticalLocation == VerticalLocation.TOP;
        int tabYPosition = isTopLine ? -28 : guiHeight - 4;
        int tabXOffset = 28 * tabIndex;
        return new int[]{startLeft ? tabXOffset : guiWidth - 28 - tabXOffset, tabYPosition, 28, 32};
    }

    private static final class BottomTextures {
        private static final TextureArea startTabInactiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.0, 0.5, 0.3333333333333333, 0.5);
        private static final TextureArea startTabActiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.0, 0.0, 0.3333333333333333, 0.5);
        private static final TextureArea middleTabInactiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.3333333333333333, 0.5, 0.3333333333333333, 0.5);
        private static final TextureArea middleTabActiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.3333333333333333, 0.0, 0.3333333333333333, 0.5);
        private static final TextureArea endTabInactiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.6666666666666666, 0.5, 0.3333333333333333, 0.5);
        private static final TextureArea endTabActiveTexture = TabListRenderer.TABS_BOTTOM_TEXTURE.getSubArea(0.6666666666666666, 0.0, 0.3333333333333333, 0.5);

        private BottomTextures() {
        }

        private static TextureArea getTabTexture(boolean isTabFirst, boolean startLeft, boolean isTabSelected) {
            return isTabFirst ? (startLeft ? (isTabSelected ? startTabActiveTexture : startTabInactiveTexture) : (isTabSelected ? endTabActiveTexture : endTabInactiveTexture)) : (isTabSelected ? middleTabActiveTexture : middleTabInactiveTexture);
        }
    }

    private static final class TopTextures {
        private static final TextureArea startTabInactiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.0, 0.0, 0.3333333333333333, 0.5);
        private static final TextureArea startTabActiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.0, 0.5, 0.3333333333333333, 0.5);
        private static final TextureArea middleTabInactiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.3333333333333333, 0.0, 0.3333333333333333, 0.5);
        private static final TextureArea middleTabActiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.3333333333333333, 0.5, 0.3333333333333333, 0.5);
        private static final TextureArea endTabInactiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.6666666666666666, 0.0, 0.3333333333333333, 0.5);
        private static final TextureArea endTabActiveTexture = TabListRenderer.TABS_TOP_TEXTURE.getSubArea(0.6666666666666666, 0.5, 0.3333333333333333, 0.5);

        private TopTextures() {
        }

        private static TextureArea getTabTexture(boolean isTabFirst, boolean startLeft, boolean isTabSelected) {
            return isTabFirst ? (startLeft ? (isTabSelected ? startTabActiveTexture : startTabInactiveTexture) : (isTabSelected ? endTabActiveTexture : endTabInactiveTexture)) : (isTabSelected ? middleTabActiveTexture : middleTabInactiveTexture);
        }
    }

    public static enum VerticalLocation {
        TOP,
        BOTTOM;

    }

    public static enum HorizontalStartCorner {
        LEFT,
        RIGHT;

    }
}

