/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.metaitem;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.common.ConfigHolder;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class DefaultSubItemHandler
implements ISubItemHandler {
    @Override
    public String getItemSubType(ItemStack itemStack) {
        return DefaultSubItemHandler.getFluidContainerSubType(itemStack);
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)itemStack.func_77946_l());
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            electricItem.charge(Long.MAX_VALUE, Integer.MAX_VALUE, true, false);
            subItems.add((Object)itemStack);
        }
        if (creativeTab == CreativeTabs.field_78027_g && itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && !ConfigHolder.hideFilledCellsInJEI) {
            DefaultSubItemHandler.addFluidContainerVariants(itemStack, subItems);
        }
    }

    public static String getFluidContainerSubType(ItemStack itemStack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            IFluidTankProperties fluidTankProperties = fluidHandler.getTankProperties()[0];
            FluidStack fluid = fluidTankProperties.getContents();
            return String.format("f=%s", fluid == null ? "empty" : fluid.getFluid().getName());
        }
        return "";
    }

    public static void addFluidContainerVariants(ItemStack itemStack, List<ItemStack> subItems) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack containerStack = itemStack.func_77946_l();
            IFluidHandlerItem fluidContainer = (IFluidHandlerItem)containerStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidContainer == null) continue;
            fluidContainer.fill(new FluidStack(fluid, Integer.MAX_VALUE), true);
            if (fluidContainer.drain(Integer.MAX_VALUE, false) == null) continue;
            subItems.add(fluidContainer.getContainer());
        }
    }
}

