/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.RoughSolidMaterial;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="gregtech")
public class ToolMetaItemListener {
    private static final Object DUMMY_OBJECT = new Object();
    private static final ThreadLocal<Object> harvesting = new ThreadLocal();

    @SubscribeEvent
    public static void onXpOrbPickup(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityXPOrb xpOrb = event.getOrb();
        ItemStack itemStack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ToolMetaItem) {
            ToolMetaItem toolMetaItem = (ToolMetaItem)itemStack.func_77973_b();
            int maxDurabilityRegain = ToolMetaItemListener.xpToDurability(xpOrb.field_70530_e);
            int durabilityRegained = toolMetaItem.regainItemDurability(itemStack, maxDurabilityRegain);
            xpOrb.field_70530_e -= ToolMetaItemListener.durabilityToXp(durabilityRegained);
        }
    }

    @SubscribeEvent
    public static void onAnvilChange(AnvilUpdateEvent event) {
        ItemStack firstStack = event.getLeft();
        ItemStack secondStack = event.getRight();
        if (!firstStack.func_190926_b() && !secondStack.func_190926_b() && firstStack.func_77973_b() instanceof ToolMetaItem) {
            ToolMetaItem toolMetaItem = (ToolMetaItem)firstStack.func_77973_b();
            ToolMetaItem.MetaToolValueItem toolValueItem = (ToolMetaItem.MetaToolValueItem)toolMetaItem.getItem(firstStack);
            if (toolValueItem == null) {
                return;
            }
            SolidMaterial toolMaterial = ToolMetaItem.getToolMaterial(firstStack);
            OrePrefix solidPrefix = ToolMetaItemListener.getSolidPrefix(toolMaterial);
            UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry(secondStack);
            double toolDamage = (double)toolMetaItem.getItemDamage(firstStack) / ((double)toolMetaItem.getMaxItemDamage(firstStack) * 1.0);
            double materialForFullRepair = toolValueItem.getAmountOfMaterialToRepair(firstStack);
            int durabilityPerUnit = (int)Math.ceil((double)toolMetaItem.getMaxItemDamage(firstStack) / materialForFullRepair);
            int materialUnitsRequired = Math.min(secondStack.func_190916_E(), (int)Math.ceil(toolDamage * materialForFullRepair));
            int repairCost = (MathHelper.func_76125_a((int)toolMaterial.harvestLevel, (int)2, (int)3) - 1) * materialUnitsRequired;
            if (toolDamage > 0.0 && materialUnitsRequired > 0 && unificationEntry != null && unificationEntry.material == toolMaterial && unificationEntry.orePrefix == solidPrefix) {
                int durabilityToRegain = durabilityPerUnit * materialUnitsRequired;
                ItemStack resultStack = firstStack.func_77946_l();
                toolMetaItem.regainItemDurability(resultStack, durabilityToRegain);
                event.setMaterialCost(materialUnitsRequired);
                event.setCost(repairCost);
                event.setOutput(resultStack);
            }
        }
    }

    private static OrePrefix getSolidPrefix(SolidMaterial material) {
        if (material instanceof IngotMaterial) {
            return OrePrefix.ingot;
        }
        if (material instanceof GemMaterial) {
            return OrePrefix.gem;
        }
        if (material instanceof RoughSolidMaterial) {
            return ((RoughSolidMaterial)material).solidFormSupplier.get();
        }
        return null;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        boolean isRecursiveCall;
        EntityPlayer harvester = event.getHarvester();
        List drops = event.getDrops();
        if (harvester == null) {
            return;
        }
        ItemStack stackInHand = harvester.func_184586_b(EnumHand.MAIN_HAND);
        if (stackInHand.func_190926_b() || !(stackInHand.func_77973_b() instanceof ToolMetaItem)) {
            return;
        }
        ToolMetaItem toolMetaItem = (ToolMetaItem)stackInHand.func_77973_b();
        boolean bl = isRecursiveCall = harvesting.get() == DUMMY_OBJECT;
        if (!isRecursiveCall) {
            harvesting.set(DUMMY_OBJECT);
            toolMetaItem.onBlockDropsHarvested(stackInHand, event.getWorld(), event.getPos(), event.getState(), harvester, drops);
            harvesting.set(null);
        }
    }
}

