/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.google.common.base.Preconditions;
import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.gui.IUIHolder;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.IRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TickableTileEntityBase;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.GTLog;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class MetaTileEntityHolder
extends TickableTileEntityBase
implements IUIHolder {
    private MetaTileEntity metaTileEntity;
    private boolean needToUpdateLightning = false;
    private static List<String> registeredModIDs = null;

    public MetaTileEntity getMetaTileEntity() {
        return this.metaTileEntity;
    }

    public MetaTileEntity setMetaTileEntity(MetaTileEntity sampleMetaTileEntity) {
        Preconditions.checkNotNull((Object)sampleMetaTileEntity, (Object)"metaTileEntity");
        this.metaTileEntity = sampleMetaTileEntity.createMetaTileEntity(this);
        this.metaTileEntity.holder = this;
        this.metaTileEntity.onAttached();
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.updateBlockOpacity();
            this.writeCustomData(-1, buffer -> {
                buffer.func_150787_b(GregTechAPI.META_TILE_ENTITY_REGISTRY.getIdByObjectName(this.metaTileEntity.metaTileEntityId));
                this.metaTileEntity.writeInitialSyncData((PacketBuffer)buffer);
            });
            this.needToUpdateLightning = true;
            this.field_145850_b.func_190524_a(this.func_174877_v(), this.func_145838_q(), this.func_174877_v());
            this.func_70296_d();
        }
        return this.metaTileEntity;
    }

    private void updateBlockOpacity() {
        IBlockState currentState = this.field_145850_b.func_180495_p(this.func_174877_v());
        boolean isMetaTileEntityOpaque = this.metaTileEntity.isOpaqueCube();
        if ((Boolean)currentState.func_177229_b((IProperty)BlockMachine.OPAQUE) != isMetaTileEntityOpaque) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), currentState.func_177226_a((IProperty)BlockMachine.OPAQUE, (Comparable)Boolean.valueOf(isMetaTileEntityOpaque)));
        }
    }

    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("MetaId", 8)) {
            String metaTileEntityIdRaw = compound.func_74779_i("MetaId");
            ResourceLocation metaTileEntityId = metaTileEntityIdRaw.indexOf(58) == -1 ? MetaTileEntityHolder.convertMetaTileEntityId(metaTileEntityIdRaw) : new ResourceLocation(metaTileEntityIdRaw);
            MetaTileEntity sampleMetaTileEntity = metaTileEntityId == null ? null : (MetaTileEntity)GregTechAPI.META_TILE_ENTITY_REGISTRY.func_82594_a(metaTileEntityId);
            NBTTagCompound metaTileEntityData = compound.func_74775_l("MetaTileEntity");
            if (sampleMetaTileEntity != null) {
                this.metaTileEntity = sampleMetaTileEntity.createMetaTileEntity(this);
                this.metaTileEntity.holder = this;
                this.metaTileEntity.readFromNBT(metaTileEntityData);
            } else {
                GTLog.logger.error("Failed to load MetaTileEntity with invalid ID " + metaTileEntityIdRaw);
            }
        }
    }

    private static ResourceLocation convertMetaTileEntityId(String metaTileEntityIdOld) {
        GTControlledRegistry<ResourceLocation, MetaTileEntity> registry = GregTechAPI.META_TILE_ENTITY_REGISTRY;
        ResourceLocation gregtechId = new ResourceLocation("gregtech", metaTileEntityIdOld);
        if (registry.func_148741_d(gregtechId)) {
            return gregtechId;
        }
        if (registeredModIDs == null) {
            registeredModIDs = registry.func_148742_b().stream().map(ResourceLocation::func_110624_b).distinct().collect(Collectors.toList());
            registeredModIDs.remove("gregtech");
        }
        for (String registryModId : registeredModIDs) {
            ResourceLocation probableId = new ResourceLocation(registryModId, metaTileEntityIdOld);
            if (!registry.func_148741_d(probableId)) continue;
            return probableId;
        }
        GTLog.logger.error("Failed to convert old MetaTileEntity string ID " + metaTileEntityIdOld);
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.metaTileEntity != null) {
            compound.func_74778_a("MetaId", this.metaTileEntity.metaTileEntityId.toString());
            NBTTagCompound metaTileEntityData = new NBTTagCompound();
            this.metaTileEntity.writeToNBT(metaTileEntityData);
            compound.func_74782_a("MetaTileEntity", (NBTBase)metaTileEntityData);
        }
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        Object metaTileEntityValue = this.metaTileEntity == null ? null : this.metaTileEntity.getCoverCapability(capability, facing);
        return metaTileEntityValue != null || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object metaTileEntityValue = this.metaTileEntity == null ? null : (Object)this.metaTileEntity.getCoverCapability(capability, facing);
        return (T)(metaTileEntityValue != null ? metaTileEntityValue : super.getCapability(capability, facing));
    }

    @Override
    public void func_73660_a() {
        if (this.metaTileEntity != null) {
            this.metaTileEntity.update();
        }
        if (this.needToUpdateLightning) {
            this.func_145831_w().func_175664_x(this.func_174877_v());
            this.needToUpdateLightning = false;
        }
        super.func_73660_a();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        if (this.metaTileEntity != null) {
            buf.writeBoolean(true);
            buf.func_150787_b(GregTechAPI.META_TILE_ENTITY_REGISTRY.getIdByObjectName(this.metaTileEntity.metaTileEntityId));
            this.metaTileEntity.writeInitialSyncData(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        if (buf.readBoolean()) {
            int metaTileEntityId = buf.func_150792_a();
            this.setMetaTileEntity(GregTechAPI.META_TILE_ENTITY_REGISTRY.getObjectById(metaTileEntityId));
            this.metaTileEntity.receiveInitialSyncData(buf);
            this.scheduleChunkForRenderUpdate();
            this.needToUpdateLightning = true;
        }
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buffer) {
        if (discriminator == -1) {
            int metaTileEntityId = buffer.func_150792_a();
            this.setMetaTileEntity(GregTechAPI.META_TILE_ENTITY_REGISTRY.getObjectById(metaTileEntityId));
            this.metaTileEntity.receiveInitialSyncData(buffer);
            this.scheduleChunkForRenderUpdate();
            this.needToUpdateLightning = true;
        } else if (this.metaTileEntity != null) {
            this.metaTileEntity.receiveCustomData(discriminator, buffer);
        }
    }

    @Override
    public boolean isValid() {
        return !super.func_145837_r() && this.metaTileEntity != null;
    }

    @Override
    public boolean isRemote() {
        return this.func_145831_w().field_72995_K;
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    public void onLoad() {
        super.onLoad();
        if (this.metaTileEntity != null) {
            this.metaTileEntity.onLoad();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.metaTileEntity != null) {
            this.metaTileEntity.onUnload();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_189667_a(Rotation rotationIn) {
        if (this.metaTileEntity != null) {
            this.metaTileEntity.setFrontFacing(rotationIn.func_185831_a(this.metaTileEntity.getFrontFacing()));
        }
    }

    public void func_189668_a(Mirror mirrorIn) {
        if (this.metaTileEntity != null) {
            this.func_189667_a(mirrorIn.func_185800_a(this.metaTileEntity.getFrontFacing()));
        }
    }

    public boolean shouldRenderInPass(int pass) {
        if (this.metaTileEntity == null) {
            return false;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior cover = this.metaTileEntity.getCoverAtSide(side);
            if (cover instanceof IFastRenderMetaTileEntity && ((IFastRenderMetaTileEntity)((Object)cover)).shouldRenderInPass(pass)) {
                return true;
            }
            if (!(cover instanceof IRenderMetaTileEntity) || !((IRenderMetaTileEntity)((Object)cover)).shouldRenderInPass(pass)) continue;
            return true;
        }
        if (this.metaTileEntity instanceof IRenderMetaTileEntity) {
            return ((IRenderMetaTileEntity)((Object)this.metaTileEntity)).shouldRenderInPass(pass);
        }
        if (this.metaTileEntity instanceof IFastRenderMetaTileEntity) {
            return ((IFastRenderMetaTileEntity)((Object)this.metaTileEntity)).shouldRenderInPass(pass);
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.metaTileEntity instanceof IRenderMetaTileEntity) {
            return ((IRenderMetaTileEntity)((Object)this.metaTileEntity)).getRenderBoundingBox();
        }
        if (this.metaTileEntity instanceof IFastRenderMetaTileEntity) {
            return ((IFastRenderMetaTileEntity)((Object)this.metaTileEntity)).getRenderBoundingBox();
        }
        return new AxisAlignedBB(this.func_174877_v());
    }

    public boolean canRenderBreaking() {
        return false;
    }
}

