/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.render.OrientedOverlayRenderer;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class WorkableTieredMetaTileEntity
extends TieredMetaTileEntity {
    protected final RecipeLogicEnergy workable;
    protected final OrientedOverlayRenderer renderer;

    public WorkableTieredMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, OrientedOverlayRenderer renderer, int tier) {
        super(metaTileEntityId, tier);
        this.renderer = renderer;
        this.workable = this.createWorkable(recipeMap);
        this.initializeInventory();
        this.reinitializeEnergyContainer();
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new RecipeLogicEnergy(this, recipeMap, () -> this.energyContainer);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return 2L;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.renderer.render(renderState, translation, pipeline, this.getFrontFacing(), this.workable.isActive());
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.workable == null) {
            return new ItemStackHandler(0);
        }
        return new ItemStackHandler(this.workable.recipeMap.getMaxInputs());
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.workable == null) {
            return new ItemStackHandler(0);
        }
        return new ItemStackHandler(this.workable.recipeMap.getMaxOutputs());
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        if (this.workable == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FilteredFluidHandler[] fluidImports = new FilteredFluidHandler[this.workable.recipeMap.getMaxFluidInputs()];
        for (int i = 0; i < fluidImports.length; ++i) {
            FilteredFluidHandler filteredFluidHandler = new FilteredFluidHandler(this.getInputTankCapacity(i));
            filteredFluidHandler.setFillPredicate(this::canInputFluid);
            fluidImports[i] = filteredFluidHandler;
        }
        return new FluidTankList(false, (IFluidTank[])fluidImports);
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        if (this.workable == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FluidTank[] fluidExports = new FluidTank[this.workable.recipeMap.getMaxFluidOutputs()];
        for (int i = 0; i < fluidExports.length; ++i) {
            fluidExports[i] = new FluidTank(this.getOutputTankCapacity(i));
        }
        return new FluidTankList(false, (IFluidTank[])fluidExports);
    }

    protected boolean canInputFluid(FluidStack inputFluid) {
        RecipeMap recipeMap = this.workable.recipeMap;
        if (recipeMap.canInputFluidForce(inputFluid.getFluid())) {
            return true;
        }
        HashSet<Recipe> matchingRecipes = null;
        for (IFluidTank fluidTank : this.importFluids) {
            FluidStack fluidInTank = fluidTank.getFluid();
            if (fluidInTank == null) continue;
            if (matchingRecipes == null) {
                matchingRecipes = new HashSet<Recipe>(recipeMap.getRecipesForFluid(fluidInTank));
                continue;
            }
            matchingRecipes.removeIf(recipe -> !recipe.hasInputFluid(fluidInTank));
        }
        if (matchingRecipes == null) {
            return !recipeMap.getRecipesForFluid(inputFluid).isEmpty();
        }
        return matchingRecipes.stream().anyMatch(recipe -> recipe.hasInputFluid(inputFluid));
    }

    protected int getInputTankCapacity(int index) {
        return 64000;
    }

    protected int getOutputTankCapacity(int index) {
        return 64000;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VN[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
    }
}

