/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import com.google.common.collect.ImmutableList;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.MatchingMode;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.recipes.recipeproperties.RecipePropertyStorage;
import gregtech.api.util.GTUtility;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class Recipe {
    private final List<CountableIngredient> inputs;
    private final NonNullList<ItemStack> outputs;
    private final List<ChanceEntry> chancedOutputs;
    private final List<FluidStack> fluidInputs;
    private final List<FluidStack> fluidOutputs;
    private final int duration;
    private final int EUt;
    private final boolean hidden;
    private final RecipePropertyStorage recipePropertyStorage = new RecipePropertyStorage();

    public static int getMaxChancedValue() {
        return 10000;
    }

    public static String formatChanceValue(int outputChance) {
        return String.format("%.2f", (double)outputChance / ((double)Recipe.getMaxChancedValue() * 1.0) * 100.0);
    }

    public Recipe(List<CountableIngredient> inputs, List<ItemStack> outputs, List<ChanceEntry> chancedOutputs, List<FluidStack> fluidInputs, List<FluidStack> fluidOutputs, int duration, int EUt, boolean hidden) {
        this.inputs = NonNullList.func_191196_a();
        this.inputs.addAll(inputs);
        this.outputs = NonNullList.func_191196_a();
        this.outputs.addAll(outputs);
        this.chancedOutputs = new ArrayList<ChanceEntry>(chancedOutputs);
        this.fluidInputs = ImmutableList.copyOf(fluidInputs);
        this.fluidOutputs = ImmutableList.copyOf(fluidOutputs);
        this.duration = duration;
        this.EUt = EUt;
        this.hidden = hidden;
        this.inputs.sort(Comparator.comparing(CountableIngredient::getCount).reversed());
    }

    @Deprecated
    public Recipe(List<CountableIngredient> inputs, List<ItemStack> outputs, List<ChanceEntry> chancedOutputs, List<FluidStack> fluidInputs, List<FluidStack> fluidOutputs, Map<String, Object> recipeProperties, int duration, int EUt, boolean hidden) {
        this(inputs, outputs, chancedOutputs, fluidInputs, fluidOutputs, duration, EUt, hidden);
        this.recipePropertyStorage.storeOldFormat(recipeProperties);
    }

    public final boolean matches(boolean consumeIfSuccessful, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs, MatchingMode matchingMode) {
        return this.matches(consumeIfSuccessful, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs), matchingMode);
    }

    public final boolean matches(boolean consumeIfSuccessful, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        return this.matches(consumeIfSuccessful, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs), MatchingMode.DEFAULT);
    }

    public boolean matches(boolean consumeIfSuccessful, List<ItemStack> inputs, List<FluidStack> fluidInputs) {
        return this.matches(consumeIfSuccessful, inputs, fluidInputs, MatchingMode.DEFAULT);
    }

    public boolean matches(boolean consumeIfSuccessful, List<ItemStack> inputs, List<FluidStack> fluidInputs, MatchingMode matchingMode) {
        Pair<Boolean, Integer[]> fluids = null;
        Pair<Boolean, Integer[]> items = null;
        if (matchingMode == MatchingMode.IGNORE_FLUIDS ? this.getInputs().isEmpty() : (Boolean)(fluids = this.matchesFluid(fluidInputs)).getKey() == false) {
            return false;
        }
        if (matchingMode == MatchingMode.IGNORE_ITEMS ? this.getFluidInputs().isEmpty() : (Boolean)(items = this.matchesItems(inputs)).getKey() == false) {
            return false;
        }
        if (consumeIfSuccessful && matchingMode == MatchingMode.DEFAULT) {
            int i;
            Integer[] fluidAmountInTank = (Integer[])fluids.getValue();
            Integer[] itemAmountInSlot = (Integer[])items.getValue();
            for (i = 0; i < fluidAmountInTank.length; ++i) {
                FluidStack fluidStack = fluidInputs.get(i);
                int fluidAmount = fluidAmountInTank[i];
                if (fluidStack == null || fluidStack.amount == fluidAmount) continue;
                fluidStack.amount = fluidAmount;
                if (fluidStack.amount != 0) continue;
                fluidInputs.set(i, null);
            }
            for (i = 0; i < itemAmountInSlot.length; ++i) {
                ItemStack itemInSlot = inputs.get(i);
                int itemAmount = itemAmountInSlot[i];
                if (itemInSlot.func_190926_b() || itemInSlot.func_190916_E() == itemAmount) continue;
                itemInSlot.func_190920_e(itemAmountInSlot[i].intValue());
            }
        }
        return true;
    }

    private Pair<Boolean, Integer[]> matchesItems(List<ItemStack> inputs) {
        Integer[] itemAmountInSlot = new Integer[inputs.size()];
        for (int i = 0; i < itemAmountInSlot.length; ++i) {
            ItemStack itemInSlot = inputs.get(i);
            itemAmountInSlot[i] = itemInSlot.func_190926_b() ? 0 : itemInSlot.func_190916_E();
        }
        for (CountableIngredient ingredient : this.inputs) {
            int ingredientAmount = ingredient.getCount();
            boolean isNotConsumed = false;
            if (ingredientAmount == 0) {
                ingredientAmount = 1;
                isNotConsumed = true;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                ItemStack inputStack = inputs.get(i);
                if (inputStack.func_190926_b() || !ingredient.getIngredient().apply(inputStack)) continue;
                int itemAmountToConsume = Math.min(itemAmountInSlot[i], ingredientAmount);
                ingredientAmount -= itemAmountToConsume;
                if (!isNotConsumed) {
                    Integer[] integerArray = itemAmountInSlot;
                    int n = i;
                    Integer.valueOf(integerArray[n] - itemAmountToConsume);
                }
                if (ingredientAmount == 0) break;
            }
            if (ingredientAmount <= 0) continue;
            return Pair.of((Object)false, (Object)itemAmountInSlot);
        }
        return Pair.of((Object)true, (Object)itemAmountInSlot);
    }

    private Pair<Boolean, Integer[]> matchesFluid(List<FluidStack> fluidInputs) {
        Integer[] fluidAmountInTank = new Integer[fluidInputs.size()];
        for (int i = 0; i < fluidAmountInTank.length; ++i) {
            FluidStack fluidInTank = fluidInputs.get(i);
            fluidAmountInTank[i] = fluidInTank == null ? 0 : fluidInTank.amount;
        }
        for (FluidStack fluid : this.fluidInputs) {
            int fluidAmount = fluid.amount;
            boolean isNotConsumed = false;
            if (fluidAmount == 0) {
                fluidAmount = 1;
                isNotConsumed = true;
            }
            for (int i = 0; i < fluidInputs.size(); ++i) {
                FluidStack tankFluid = fluidInputs.get(i);
                if (tankFluid == null || !tankFluid.isFluidEqual(fluid)) continue;
                int fluidAmountToConsume = Math.min(fluidAmountInTank[i], fluidAmount);
                fluidAmount -= fluidAmountToConsume;
                if (!isNotConsumed) {
                    Integer[] integerArray = fluidAmountInTank;
                    int n = i;
                    Integer.valueOf(integerArray[n] - fluidAmountToConsume);
                }
                if (fluidAmount == 0) break;
            }
            if (fluidAmount <= 0) continue;
            return Pair.of((Object)false, (Object)fluidAmountInTank);
        }
        return Pair.of((Object)true, (Object)fluidAmountInTank);
    }

    public List<CountableIngredient> getInputs() {
        return this.inputs;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getResultItemOutputs(int maxOutputSlots, Random random, int tier) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        List<ChanceEntry> chancedOutputsList = this.getChancedOutputs();
        int maxChancedSlots = maxOutputSlots - outputs.size();
        if (chancedOutputsList.size() > maxChancedSlots) {
            chancedOutputsList = chancedOutputsList.subList(0, Math.max(0, maxChancedSlots));
        }
        for (ChanceEntry chancedOutput : chancedOutputsList) {
            int outputChance = RecipeMap.getChanceFunction().chanceFor(chancedOutput.getChance(), chancedOutput.getBoostPerTier(), tier);
            if (random.nextInt(Recipe.getMaxChancedValue()) > outputChance) continue;
            outputs.add(chancedOutput.getItemStack().func_77946_l());
        }
        return outputs;
    }

    public List<ItemStack> getAllItemOutputs(int maxOutputSlots) {
        List<Object> outputs = new ArrayList<ItemStack>();
        outputs.addAll((Collection<ItemStack>)GTUtility.copyStackList(this.getOutputs()));
        outputs.addAll(this.getChancedOutputs().stream().map(ChanceEntry::getItemStack).collect(Collectors.toList()));
        if (outputs.size() > maxOutputSlots) {
            outputs = outputs.subList(0, maxOutputSlots);
        }
        return outputs;
    }

    public List<ChanceEntry> getChancedOutputs() {
        return this.chancedOutputs;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public boolean hasInputFluid(FluidStack fluid) {
        for (FluidStack fluidStack : this.fluidInputs) {
            if (!fluidStack.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEUt() {
        return this.EUt;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasValidInputsForDisplay() {
        boolean hasValidInputs = true;
        for (CountableIngredient ingredient : this.inputs) {
            ItemStack[] matchingItems = ingredient.getIngredient().func_193365_a();
            hasValidInputs &= Arrays.stream(matchingItems).anyMatch(s -> !s.func_190926_b());
        }
        return hasValidInputs;
    }

    public RecipePropertyStorage getRecipePropertyStorage() {
        return this.recipePropertyStorage;
    }

    @Deprecated
    public boolean getBooleanProperty(String key) {
        return (Boolean)this.getProperty(key);
    }

    @Deprecated
    public int getIntegerProperty(String key) {
        return (Integer)this.getProperty(key);
    }

    @Deprecated
    public String getStringProperty(String key) {
        return (String)this.getProperty(key);
    }

    @Deprecated
    public <T> T getProperty(String key) {
        AbstractMap.SimpleEntry<RecipeProperty<?>, Object> recipePropertySet = this.getRecipePropertyStorage().getRecipeProperty(key);
        if (recipePropertySet == null) {
            throw new IllegalArgumentException();
        }
        return (T)recipePropertySet.getKey().castValue(recipePropertySet.getValue());
    }

    public static class ChanceEntry {
        private final ItemStack itemStack;
        private final int chance;
        private final int boostPerTier;

        public ChanceEntry(ItemStack itemStack, int chance, int boostPerTier) {
            this.itemStack = itemStack.func_77946_l();
            this.chance = chance;
            this.boostPerTier = boostPerTier;
        }

        public ItemStack getItemStack() {
            return this.itemStack.func_77946_l();
        }

        public int getChance() {
            return this.chance;
        }

        public int getBoostPerTier() {
            return this.boostPerTier;
        }
    }
}

