/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.FusionEUToStartProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FusionRecipeBuilder
extends RecipeBuilder<FusionRecipeBuilder> {
    private long EUToStart;

    public FusionRecipeBuilder() {
    }

    public FusionRecipeBuilder(Recipe recipe, RecipeMap<FusionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
        this.EUToStart = recipe.getRecipePropertyStorage().getRecipePropertyValue(FusionEUToStartProperty.getInstance(), 0L);
    }

    public FusionRecipeBuilder(RecipeBuilder<FusionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public FusionRecipeBuilder copy() {
        return new FusionRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(String key, Object value) {
        if (key.equals("eu_to_start")) {
            this.EUToStart(((Number)value).longValue());
            return true;
        }
        return false;
    }

    public FusionRecipeBuilder EUToStart(long EUToStart) {
        if (EUToStart <= 0L) {
            GTLog.logger.error("EU to start cannot be less than or equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.EUToStart = EUToStart;
        return this;
    }

    @Override
    public ValidationResult<Recipe> build() {
        Recipe recipe = new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden);
        if (!recipe.getRecipePropertyStorage().store((Map<RecipeProperty<?>, Object>)ImmutableMap.of((Object)FusionEUToStartProperty.getInstance(), (Object)this.EUToStart))) {
            return ValidationResult.newResult(EnumValidationResult.INVALID, recipe);
        }
        return ValidationResult.newResult(this.finalizeAndValidate(), recipe);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(FusionEUToStartProperty.getInstance().getKey(), this.EUToStart).toString();
    }
}

