/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import java.util.function.DoubleSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RecipeMapGroupOutput
extends RecipeMap<SimpleRecipeBuilder>
implements SimpleMachineMetaTileEntity.RecipeMapWithConfigButton {
    public RecipeMapGroupOutput(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, int amperage, SimpleRecipeBuilder defaultRecipe) {
        super(unlocalizedName, minInputs, maxInputs, minOutputs, maxOutputs, minFluidInputs, maxFluidInputs, minFluidOutputs, maxFluidOutputs, defaultRecipe);
    }

    @Override
    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids) {
        return super.createUITemplate(() -> 0.0, importItems, exportItems, importFluids, exportFluids);
    }

    @Override
    public ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.widget(new ProgressWidget(progressSupplier, 77, 22, 21, 20, this.progressBarTexture, this.moveType));
        this.addInventorySlotGroup(builder, importItems, importFluids, false);
        BooleanWrapper booleanWrapper = new BooleanWrapper();
        ServerWidgetGroup itemOutputGroup = this.createItemOutputWidgetGroup(exportItems, new ServerWidgetGroup(() -> !booleanWrapper.getCurrentMode()));
        ServerWidgetGroup fluidOutputGroup = this.createFluidOutputWidgetGroup(exportFluids, new ServerWidgetGroup(booleanWrapper::getCurrentMode));
        builder.widget(itemOutputGroup).widget(fluidOutputGroup);
        ToggleButtonWidget buttonWidget = new ToggleButtonWidget(115, 62, 18, 18, GuiTextures.BUTTON_SWITCH_VIEW, booleanWrapper::getCurrentMode, booleanWrapper::setCurrentMode).setTooltipText("gregtech.gui.toggle_view");
        builder.widget(buttonWidget);
        return builder;
    }

    @Override
    public int getLeftButtonOffset() {
        return 0;
    }

    @Override
    public int getRightButtonOffset() {
        return 18;
    }

    protected ServerWidgetGroup createItemOutputWidgetGroup(IItemHandlerModifiable itemHandler, ServerWidgetGroup widgetGroup) {
        int[] inputSlotGrid = RecipeMapGroupOutput.determineSlotsGrid(itemHandler.getSlots());
        int itemSlotsToLeft = inputSlotGrid[0];
        int itemSlotsToDown = inputSlotGrid[1];
        int startInputsX = 106;
        int startInputsY = 32 - (int)((double)itemSlotsToDown / 2.0 * 18.0);
        for (int i = 0; i < itemSlotsToDown; ++i) {
            for (int j = 0; j < itemSlotsToLeft; ++j) {
                int slotIndex = i * itemSlotsToLeft + j;
                int x = startInputsX + 18 * j;
                int y = startInputsY + 18 * i;
                widgetGroup.addWidget(new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, false).setBackgroundTexture(this.getOverlaysForSlot(true, false, false)));
            }
        }
        return widgetGroup;
    }

    protected ServerWidgetGroup createFluidOutputWidgetGroup(IMultipleTankHandler fluidHandler, ServerWidgetGroup widgetGroup) {
        int[] inputSlotGrid = RecipeMapGroupOutput.determineSlotsGrid(fluidHandler.getTanks());
        int itemSlotsToLeft = inputSlotGrid[0];
        int itemSlotsToDown = inputSlotGrid[1];
        int startInputsX = 106;
        int startInputsY = 32 - (int)((double)itemSlotsToDown / 2.0 * 18.0);
        for (int i = 0; i < itemSlotsToDown; ++i) {
            for (int j = 0; j < itemSlotsToLeft; ++j) {
                int slotIndex = i * itemSlotsToLeft + j;
                int x = startInputsX + 18 * j;
                int y = startInputsY + 18 * i;
                widgetGroup.addWidget(new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(this.getOverlaysForSlot(true, true, false)).setContainerClicking(true, false));
            }
        }
        return widgetGroup;
    }

    private static class BooleanWrapper {
        private boolean currentMode;

        private BooleanWrapper() {
        }

        public boolean getCurrentMode() {
            return this.currentMode;
        }

        public void setCurrentMode(boolean newMode) {
            this.currentMode = newMode;
        }
    }
}

