/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.type.Material;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.Validate;

public class BlastTemperatureProperty
extends RecipeProperty<Integer> {
    private static final String KEY = "blast_furnace_temperature";
    private static final TreeMap<Integer, Object> registeredCoilTypes = new TreeMap((x, y) -> y - x);
    private static BlastTemperatureProperty INSTANCE;

    private BlastTemperatureProperty() {
        super(KEY, Integer.class);
    }

    public static BlastTemperatureProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BlastTemperatureProperty();
        }
        return INSTANCE;
    }

    @Override
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.blast_furnace_temperature", (Object[])new Object[]{value, this.getMinTierForTemperature((Integer)this.castValue(value))}), x, y, color);
    }

    private String getMinTierForTemperature(Integer value) {
        String name = "";
        for (Map.Entry<Integer, Object> coil : registeredCoilTypes.entrySet()) {
            if (value > coil.getKey()) continue;
            Object mapValue = coil.getValue();
            if (mapValue instanceof Material) {
                name = ((Material)mapValue).getLocalizedName();
                continue;
            }
            if (!(mapValue instanceof String)) continue;
            name = I18n.func_135052_a((String)((String)mapValue), (Object[])new Object[0]);
        }
        if (name.length() >= 13) {
            name = name.substring(0, 10) + "..";
        }
        return name;
    }

    public static void registerCoilType(int temperature, Material coilMaterial, String coilName) {
        Validate.notNull((Object)coilName);
        if (coilMaterial == null) {
            registeredCoilTypes.put(temperature, coilName);
        } else {
            registeredCoilTypes.put(temperature, coilMaterial);
        }
    }
}

