/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import gregtech.api.recipes.recipeproperties.DefaultProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTLog;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecipePropertyStorage {
    private static final String STACKTRACE = "Stacktrace:";
    private final Map<RecipeProperty<?>, Object> recipeProperties = new HashMap();

    public boolean store(RecipeProperty<?> recipeProperty, Object value) {
        boolean success = true;
        String key = recipeProperty.getKey();
        for (RecipeProperty<?> existingRecipeProperty : this.recipeProperties.keySet()) {
            if (!existingRecipeProperty.getKey().equals(key)) continue;
            GTLog.logger.warn("Unable to add RecipeProperty with key {} as it already exists", (Object)key);
            success = false;
        }
        if (value == null) {
            GTLog.logger.warn("Provided value is null for RecipeProperty with key {}", (Object)key);
            success = false;
        }
        try {
            recipeProperty.castValue(value);
        }
        catch (ClassCastException ex) {
            GTLog.logger.warn("Provided incorrect value for RecipeProperty with key {}", (Object)key);
            GTLog.logger.warn("Full exception:", (Throwable)ex);
            success = false;
        }
        if (success) {
            this.recipeProperties.put(recipeProperty, value);
        } else {
            GTLog.logger.warn(STACKTRACE, (Throwable)new IllegalArgumentException());
        }
        return success;
    }

    public boolean store(Map<RecipeProperty<?>, Object> recipeProperties) {
        boolean success = true;
        for (Map.Entry<RecipeProperty<?>, Object> recipePropertyEntry : recipeProperties.entrySet()) {
            if (this.store(recipePropertyEntry.getKey(), recipePropertyEntry.getValue())) continue;
            success = false;
        }
        return success;
    }

    @Deprecated
    public boolean storeOldFormat(Map<String, Object> recipeProperties) {
        boolean success = true;
        for (Map.Entry<String, Object> recipePropertyEntry : recipeProperties.entrySet()) {
            Object value = recipePropertyEntry.getValue();
            String key = recipePropertyEntry.getKey();
            if (value != null) {
                DefaultProperty recipeProperty = new DefaultProperty(key, value.getClass());
                if (this.store(recipeProperty, value)) continue;
                success = false;
                continue;
            }
            GTLog.logger.warn("Provided value is null for old RecipeProperty with key {}", (Object)key);
            GTLog.logger.warn(STACKTRACE, (Throwable)new IllegalArgumentException());
            success = false;
        }
        return success;
    }

    public int getSize() {
        return this.recipeProperties.size();
    }

    public Set<Map.Entry<RecipeProperty<?>, Object>> getRecipeProperties() {
        return this.recipeProperties.entrySet();
    }

    public <T> T getRecipePropertyValue(RecipeProperty<T> recipeProperty, T defaultValue) {
        Object value = this.recipeProperties.get(recipeProperty);
        if (value == null) {
            GTLog.logger.warn("There is no property with key {}", (Object)recipeProperty.getKey());
            GTLog.logger.warn(STACKTRACE, (Throwable)new IllegalArgumentException());
            return defaultValue;
        }
        return recipeProperty.castValue(value);
    }

    @Deprecated
    public AbstractMap.SimpleEntry<RecipeProperty<?>, Object> getRecipeProperty(String key) {
        RecipeProperty<?> recipeProperty = this.getRecipePropertyValue(key);
        if (recipeProperty != null) {
            return new AbstractMap.SimpleEntry(recipeProperty, this.recipeProperties.get(recipeProperty));
        }
        return null;
    }

    public Set<String> getRecipePropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.recipeProperties.keySet().forEach(recipeProperty -> keys.add(recipeProperty.getKey()));
        return keys;
    }

    public Object getRawRecipePropertyValue(String key) {
        RecipeProperty<?> recipeProperty = this.getRecipePropertyValue(key);
        if (recipeProperty != null) {
            return this.recipeProperties.get(recipeProperty);
        }
        return null;
    }

    private RecipeProperty<?> getRecipePropertyValue(String key) {
        for (RecipeProperty<?> recipeProperty : this.recipeProperties.keySet()) {
            if (!recipeProperty.getKey().equals(key)) continue;
            return recipeProperty;
        }
        GTLog.logger.warn("There is no property with key {}", (Object)key);
        GTLog.logger.warn(STACKTRACE, (Throwable)new IllegalArgumentException());
        return null;
    }
}

