/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipes;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.FuelRecipe")
@ZenRegister
public class FuelRecipe {
    private final FluidStack recipeFluid;
    private final int duration;
    private final long minVoltage;

    public FuelRecipe(FluidStack recipeFluid, int duration, long minVoltage) {
        this.recipeFluid = recipeFluid.copy();
        this.duration = duration;
        this.minVoltage = minVoltage;
    }

    @ZenMethod(value="create")
    @Optional.Method(modid="crafttweaker")
    public static FuelRecipe craftTweakerCreate(ILiquidStack liquidStack, int duration, long minVoltage) {
        return new FuelRecipe(CraftTweakerMC.getLiquidStack((ILiquidStack)liquidStack), duration, minVoltage);
    }

    public FluidStack getRecipeFluid() {
        return this.recipeFluid.copy();
    }

    @ZenGetter(value="duration")
    public int getDuration() {
        return this.duration;
    }

    @ZenGetter(value="minVoltage")
    public long getMinVoltage() {
        return this.minVoltage;
    }

    public boolean matches(long maxVoltage, FluidStack inputFluid) {
        return maxVoltage >= this.getMinVoltage() && this.getRecipeFluid().isFluidEqual(inputFluid);
    }

    @ZenGetter(value="fluid")
    @Optional.Method(modid="crafttweaker")
    public ILiquidStack ctGetFluid() {
        return new MCLiquidStack(this.getRecipeFluid());
    }
}

