/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SimpleOrientedCubeRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] sprites;

    public SimpleOrientedCubeRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new TextureAtlasSprite[6];
        for (CubeSide cubeSide : CubeSide.values()) {
            String fullPath = String.format("blocks/%s/%s", this.basePath, cubeSide.name().toLowerCase());
            this.sprites[cubeSide.ordinal()] = textureMap.func_174942_a(new ResourceLocation("gregtech", fullPath));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.sprites[CubeSide.FRONT.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] ops, Cuboid6 bounds, EnumFacing frontFacing) {
        Textures.renderFace(renderState, translation, ops, EnumFacing.UP, bounds, this.sprites[CubeSide.TOP.ordinal()]);
        Textures.renderFace(renderState, translation, ops, EnumFacing.DOWN, bounds, this.sprites[CubeSide.BOTTOM.ordinal()]);
        Textures.renderFace(renderState, translation, ops, frontFacing, bounds, this.sprites[CubeSide.FRONT.ordinal()]);
        Textures.renderFace(renderState, translation, ops, frontFacing.func_176734_d(), bounds, this.sprites[CubeSide.BACK.ordinal()]);
        Textures.renderFace(renderState, translation, ops, frontFacing.func_176746_e(), bounds, this.sprites[CubeSide.LEFT.ordinal()]);
        Textures.renderFace(renderState, translation, ops, frontFacing.func_176735_f(), bounds, this.sprites[CubeSide.RIGHT.ordinal()]);
    }

    private static enum CubeSide {
        FRONT,
        BACK,
        RIGHT,
        LEFT,
        TOP,
        BOTTOM;

    }
}

